/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.items;

import com.mrbysco.instrumentalmobs.platform.Services;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class InstrumentItem
extends Item {
    private final Supplier<? extends SoundEvent> sound;
    private final int cooldown;
    private final int useDuration;

    public InstrumentItem(Item.Properties properties, Supplier<? extends SoundEvent> soundSupplier, int cooldown, int duration) {
        super(properties);
        this.cooldown = cooldown;
        this.sound = soundSupplier;
        this.useDuration = duration;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.cooldown != 0) {
            player.getCooldowns().addCooldown(stack, this.cooldown);
        }
        player.playSound(this.sound.get(), 1.0f, 1.0f);
        if (Services.PLATFORM.mobsReact()) {
            InstrumentHelper.instrumentDamage((LivingEntity)player);
        }
        stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return super.use(level, player, hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return this.useDuration;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }
}

