/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.modifier;

import com.mojang.serialization.MapCodec;
import com.mrbysco.instrumentalmobs.init.InstrumentalModifiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import org.jetbrains.annotations.NotNull;

public record AddRelativeSpawnBiomeModifier(EntityType<?> originalType, EntityType<?> newType, int relativeWeight) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            WeightedList.Builder spawner = spawns.getSpawner(this.originalType.getCategory());
            ArrayList<Weighted> addedSpawns = new ArrayList<Weighted>();
            List spawnsList = spawner.getList();
            for (Weighted entry : spawnsList) {
                EntityType type = ((MobSpawnSettings.SpawnerData)entry.value()).type();
                if (type != this.originalType) continue;
                addedSpawns.add(new Weighted((Object)new MobSpawnSettings.SpawnerData(this.newType, ((MobSpawnSettings.SpawnerData)entry.value()).minCount(), ((MobSpawnSettings.SpawnerData)entry.value()).maxCount()), Math.min(1, entry.weight() / this.relativeWeight)));
            }
            if (!addedSpawns.isEmpty()) {
                spawner.addAll(addedSpawns);
            }
        }
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return InstrumentalModifiers.ADD_RELATIVE_MOB_SPAWNS.get();
    }
}

