/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.platform;

import com.mrbysco.instrumentalmobs.config.InstrumentalConfigNeoForge;
import com.mrbysco.instrumentalmobs.platform.services.IPlatformHelper;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.EventHooks;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public CreativeModeTab buildCreativeTab() {
        return CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)Blocks.NOTE_BLOCK)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.instrumentalmobs")).displayItems((displayParameters, output) -> {
            List<ItemStack> stacks = InstrumentalRegistry.ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            output.acceptAll(stacks);
        }).build();
    }

    @Override
    public Level.ExplosionInteraction getExplosionInteraction(Entity entity) {
        if (entity.level().isClientSide()) {
            return Level.ExplosionInteraction.NONE;
        }
        return EventHooks.canEntityGrief((ServerLevel)((ServerLevel)entity.level()), (Entity)entity) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
    }

    @Override
    public boolean isEnderMask(ItemStack stack, Player player, EnderMan enderMan) {
        return stack.getItem() == Blocks.CARVED_PUMPKIN.asItem();
    }

    @Override
    public boolean mobsReact() {
        return (Boolean)InstrumentalConfigNeoForge.COMMON.mobsReact.get();
    }

    @Override
    public double instrumentRange() {
        return (Double)InstrumentalConfigNeoForge.COMMON.instrumentRange.get();
    }

    @Override
    public double soundDamageChance() {
        return (Double)InstrumentalConfigNeoForge.COMMON.soundDamageChance.get();
    }

    @Override
    public double instrumentDropChance() {
        return (Double)InstrumentalConfigNeoForge.COMMON.instrumentDropChance.get();
    }

    @Override
    public double instrumentHurtChance() {
        return (Double)InstrumentalConfigNeoForge.COMMON.instrumentHurtChance.get();
    }
}

