/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.saifa.quackems_the_end_update_mod.block.ModBlocks;
import net.saifa.quackems_the_end_update_mod.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "quackems_the_end_update_mod", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.AMORITE);
        this.simpleItem(ModItems.METAL_DETECTOR);
        this.simpleItem(ModItems.AMORITE_DETECTOR);
        this.simpleItem(ModItems.END_APPLE);
        this.simpleItem(ModItems.END_COAL);
        this.simpleItem(ModItems.POLISHED_AMORITE);
        this.simpleItem(ModItems.CORRUPTED_DIAMOND);
        this.simpleItem(ModItems.ENDER_HILT);
        this.simpleItem(ModItems.AMORITE_INFUSED_BOW);
        this.simpleBlockItem(ModBlocks.END_DOOR);
        this.fenceItem(ModBlocks.END_FENCE, ModBlocks.END_PLANKS);
        this.buttonItem(ModBlocks.END_BUTTON, ModBlocks.END_PLANKS);
        this.buttonItem(ModBlocks.POLISHED_BAUXITE_BUTTON, ModBlocks.POLISHED_BAUXITE);
        this.wallItem(ModBlocks.END_WALL, ModBlocks.END_PLANKS);
        this.wallItem(ModBlocks.END_PRISMARINE_WALL, ModBlocks.END_PRISMARINE_BRICK);
        this.wallItem(ModBlocks.ENDSTONE_STRETCHER_WALL, ModBlocks.ENDSTONE_STRETCHER);
        this.evenSimplerBlockItem(ModBlocks.END_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.END_SLAB);
        this.evenSimplerBlockItem(ModBlocks.END_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.END_FENCE_GATE);
        this.evenSimplerBlockItem(ModBlocks.END_PRISMARINE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.END_PRISMARINE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.ENDSTONE_STRETCHER_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.ENDSTONE_STRETCHER_SLAB);
        this.trapdoorItem(ModBlocks.END_TRAPDOOR);
        this.handheldItem(ModItems.AMORITE_AXE);
        this.handheldItem(ModItems.AMORITE_SWORD);
        this.handheldItem(ModItems.AMORITE_HOE);
        this.handheldItem(ModItems.AMORITE_PICKAXE);
        this.handheldItem(ModItems.AMORITE_SHOVEL);
        this.handheldItem(ModItems.CORRUPTED_DIAMOND_AXE);
        this.handheldItem(ModItems.CORRUPTED_DIAMOND_SWORD);
        this.handheldItem(ModItems.CORRUPTED_DIAMOND_HOE);
        this.handheldItem(ModItems.CORRUPTED_DIAMOND_PICKAXE);
        this.handheldItem(ModItems.CORRUPTED_DIAMOND_SHOVEL);
        this.trimmedArmorItem(ModItems.AMORITE_HELMET);
        this.trimmedArmorItem(ModItems.AMORITE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.AMORITE_LEGGINGS);
        this.trimmedArmorItem(ModItems.AMORITE_BOOTS);
        this.trimmedArmorItem(ModItems.CORRUPTED_DIAMOND_HELMET);
        this.trimmedArmorItem(ModItems.CORRUPTED_DIAMOND_CHESTPLATE);
        this.trimmedArmorItem(ModItems.CORRUPTED_DIAMOND_LEGGINGS);
        this.trimmedArmorItem(ModItems.CORRUPTED_DIAMOND_BOOTS);
        this.simpleBlockItemBlockTexture(ModBlocks.END_GRASS);
        this.withExistingParent(ModItems.END_BRUTE_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.END_STALKER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "quackems_the_end_update_mod";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("quackems_the_end_update_mod", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("quackems_the_end_update_mod", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("quackems_the_end_update_mod", "item/" + itemRegistryObject.getId().getPath()));
            });
        }
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("quackems_the_end_update_mod", "item/" + item.getId().getPath()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("quackems_the_end_update_mod:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("quackems_the_end_update_mod", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("quackems_the_end_update_mod", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("quackems_the_end_update_mod", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("quackems_the_end_update_mod", "item/" + item.getId().getPath()));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("quackems_the_end_update_mod", "block/" + item.getId().getPath()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("quackems_the_end_update_mod", "item/" + item.getId().getPath()));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

