/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.saifa.quackems_the_end_update_mod.entity.animations.ModAnimationDefinitions;
import net.saifa.quackems_the_end_update_mod.entity.custom.EndBruteEntity;

public class EndBruteModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart end_brute;

    public EndBruteModel(ModelPart root) {
        this.end_brute = root.getChild("end_brute");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition end_brute = partdefinition.addOrReplaceChild("end_brute", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition torso = end_brute.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -30.0f, -3.0f, 16.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(36, 23).addBox(-1.0f, -29.0f, -4.0f, 12.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = end_brute.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(48, 0).addBox(3.0f, -15.0f, 0.0f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = end_brute.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(33, 49).addBox(-6.0f, -15.0f, 0.0f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm2 = end_brute.addOrReplaceChild("arm2", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)-26.0f, (float)-1.2896f));
        PartDefinition cube_r1 = arm2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 23).addBox(-2.0f, -2.1f, -2.5f, 4.0f, 22.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.2126f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = end_brute.addOrReplaceChild("arm1", CubeListBuilder.create(), PartPose.offset((float)10.0f, (float)-27.1778f, (float)-1.2128f));
        PartDefinition cube_r2 = arm1.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 23).addBox(-2.0f, -2.1017f, -2.5f, 4.0f, 22.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.1778f, (float)1.1615f, (float)0.1309f, (float)3.1416f, (float)0.0f));
        PartDefinition head = end_brute.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 37).addBox(-4.0f, -3.0f, -4.2f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-3.0f, -5.0f, -0.2f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.0f, -5.0f, -0.2f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(45, 49).addBox(-4.0f, -4.0f, -1.2f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(48, 18).addBox(1.0f, -4.0f, -1.2f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-30.0f, (float)-2.8f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.animateWalk(ModAnimationDefinitions.WALKING, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((EndBruteEntity)entity).idleAnimationState, ModAnimationDefinitions.IDLE, ageInTicks, 1.0f);
        this.animate(((EndBruteEntity)entity).attackAnimationState, ModAnimationDefinitions.ATTACK, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.end_brute.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.root().getChild((String)"head").yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.root().getChild((String)"head").xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.end_brute;
    }
}

