/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.saifa.quackems_the_end_update_mod.entity.animations.ModAnimationDefinitionsStalker;
import net.saifa.quackems_the_end_update_mod.entity.custom.EndStalkerEntity;

public class EndStalkerModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart EndStalker;

    public EndStalkerModel(ModelPart root) {
        this.EndStalker = root.getChild("end_stalker");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition EndStalker = partdefinition.addOrReplaceChild("end_stalker", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition head = EndStalker.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 19).addBox(-4.0f, -2.0f, -2.5f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-28.0f, (float)3.5f));
        PartDefinition arm2 = EndStalker.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-25.0f, (float)1.0f));
        PartDefinition arm1 = EndStalker.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(26, 19).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-25.0f, (float)1.0f));
        PartDefinition torso = EndStalker.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -6.5f, -3.0f, 10.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-21.5f, (float)0.0f));
        PartDefinition leg2 = EndStalker.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(8, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-15.0f, (float)0.0f));
        PartDefinition leg1 = EndStalker.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(16, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-15.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.animateWalk(ModAnimationDefinitionsStalker.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((EndStalkerEntity)entity).idleAnimationState, ModAnimationDefinitionsStalker.IDLE, ageInTicks, 1.0f);
        this.animate(((EndStalkerEntity)entity).attackAnimationState, ModAnimationDefinitionsStalker.ATTACK, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.EndStalker.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.root().getChild((String)"head").yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.root().getChild((String)"head").xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.EndStalker;
    }
}

