/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.saifa.quackems_the_end_update_mod.item.ModItems;

public enum ModArmorMaterials implements ArmorMaterial
{
    AMORITE("amorite", 400, new int[]{140, 180, 160, 120}, 25, SoundEvents.ARMOR_EQUIP_GOLD, 50.0f, 5.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.POLISHED_AMORITE.get()})),
    CORRUPTED_DIAMOND("corrupted_diamond", 200, new int[]{70, 90, 80, 60}, 45, SoundEvents.ARMOR_EQUIP_GOLD, 20.0f, 1.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CORRUPTED_DIAMOND.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int getDurabilityForType(ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.ordinal()] * this.durabilityMultiplier;
    }

    public int getDefenseForType(ArmorItem.Type pType) {
        return this.protectionAmounts[pType.ordinal()];
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public String getName() {
        return "quackems_the_end_update_mod:" + this.name;
    }

    public float getToughness() {
        return this.toughness;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{11, 16, 16, 13};
    }
}

