/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.item.custom;

import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.saifa.quackems_the_end_update_mod.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class AmoriteDetectorItem
extends Item {
    public AmoriteDetectorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (!pContext.getLevel().isClientSide) {
            BlockPos positionClicked = pContext.getClickedPos();
            Player player2 = pContext.getPlayer();
            boolean foundBlock = false;
            for (int i = 0; i <= positionClicked.getY() + 64; ++i) {
                BlockState state = pContext.getLevel().getBlockState(positionClicked.below(i));
                if (!this.isValuableBlock(state)) continue;
                this.outputValuableCoordinates(positionClicked.below(i), player2, state.getBlock());
                foundBlock = true;
                break;
            }
            if (!foundBlock) {
                player2.sendSystemMessage((Component)Component.literal((String)"No Amorite found!"));
            }
        }
        pContext.getItemInHand().hurtAndBreak(1, (LivingEntity)pContext.getPlayer(), player -> player.broadcastBreakEvent(player.getUsedItemHand()));
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.quackems_the_end_update_mod.amorite_detector.tooltip"));
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private void outputValuableCoordinates(BlockPos blockPos, Player player, Block block) {
        player.sendSystemMessage((Component)Component.literal((String)("Found " + I18n.get((String)block.getDescriptionId(), (Object[])new Object[0]) + " at (" + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ() + ")")));
    }

    private boolean isValuableBlock(BlockState state) {
        return state.is((Block)ModBlocks.AMORITE_ORE.get());
    }
}

