/*
 * Decompiled with CFR 0.152.
 */
package net.saifa.quackems_the_end_update_mod.worldgen.tree;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractTreeGrower {
    @Nullable
    protected abstract ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeature(RandomSource var1, boolean var2);

    public boolean growTree(ServerLevel pLevel, ChunkGenerator pGenerator, BlockPos pPos, BlockState pState, RandomSource pRandom) {
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey = this.getConfiguredFeature(pRandom, this.hasFlowers((LevelAccessor)pLevel, pPos));
        if (resourcekey == null) {
            return false;
        }
        Holder holder = (Holder)pLevel.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey).orElse(null);
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)pLevel, (RandomSource)pRandom, (BlockPos)pPos, (Holder)holder);
        holder = event.getFeature();
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        BlockState blockstate = pLevel.m_6425_(pPos).m_76188_();
        pLevel.m_7731_(pPos, blockstate, 4);
        if (configuredfeature.m_224953_((WorldGenLevel)pLevel, pGenerator, pRandom, pPos)) {
            if (pLevel.m_8055_(pPos) == blockstate) {
                pLevel.m_7260_(pPos, pState, blockstate, 2);
            }
            return true;
        }
        pLevel.m_7731_(pPos, pState, 4);
        return false;
    }

    private boolean hasFlowers(LevelAccessor pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pPos.m_7495_().m_122013_(2).m_122025_(2), (BlockPos)pPos.m_7494_().m_122020_(2).m_122030_(2))) {
            if (!pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13041_)) continue;
            return true;
        }
        return false;
    }
}

