/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.block.entity;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_7225;
import net.shirojr.pulchra_occultorum.block.FlagPoleBlock;
import net.shirojr.pulchra_occultorum.init.BlockEntities;
import net.shirojr.pulchra_occultorum.util.BlockStateProperties;
import net.shirojr.pulchra_occultorum.util.boilerplate.AbstractTickingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class FlagPoleBlockEntity
extends AbstractTickingBlockEntity {
    private static final int invSize = 1;
    private final class_1277 flagInventory = new class_1277(1);
    private boolean hoisted = false;
    private float hoistedState = 0.0f;
    private float hoistedTargetState = 0.0f;
    public float flagAnimationProgress = 0.0f;

    public FlagPoleBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.FLAG_POLE_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FlagPoleBlockEntity blockEntity) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!state.method_28498(BlockStateProperties.FLAG_POLE_STATE)) {
            return;
        }
        if (world.method_8320(pos.method_10074()).method_26204() instanceof FlagPoleBlock) {
            return;
        }
        blockEntity.incrementTick(false);
        if (blockEntity.getFlagInventory().method_5442()) {
            return;
        }
        blockEntity.modifyTargetHoistedState(world, pos);
        if (blockEntity.getTick() % 10 == 0 && blockEntity.isHoistStateMoving() && blockEntity.getBaseBlockPos() != null && blockEntity.getTopBlockPos() != null) {
            class_2338 soundPos = new class_2338(blockEntity.method_11016().method_10263(), class_3532.method_48781((float)blockEntity.getHoistedState(), (int)blockEntity.getBaseBlockPos().method_10264(), (int)blockEntity.getTopBlockPos().method_10264()), blockEntity.method_11016().method_10260());
            serverWorld.method_8396(null, soundPos, class_3417.field_15226, class_3419.field_15245, 1.0f, class_3532.method_16439((float)serverWorld.method_8409().method_43057(), (float)0.7f, (float)1.1f));
        }
    }

    public class_1277 getFlagInventory() {
        this.method_5431();
        return this.flagInventory;
    }

    public void syncedInventoryModification(Consumer<class_1277> inventoryConsumer) {
        inventoryConsumer.accept(this.getFlagInventory());
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
        }
    }

    @Nullable
    public class_2338 getBaseBlockPos() {
        if (this.method_10997() == null) {
            return null;
        }
        return FlagPoleBlock.getBaseBlockPos(this.method_10997(), this.method_11016());
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public boolean isHoisted() {
        return this.hoisted;
    }

    public void setHoisted(boolean hoisted) {
        this.hoisted = hoisted;
        this.method_5431();
    }

    public float getHoistedState() {
        return Math.clamp(this.hoistedState, 0.0f, 1.0f);
    }

    public boolean isFullyHoisted() {
        return this.getHoistedState() >= 1.0f;
    }

    public boolean isAtTargetHoistedState() {
        return this.getHoistedState() == this.getHoistedTargetState() && this.getHoistedState() != 0.0f;
    }

    public void setHoistedState(float hoistedState) {
        this.hoistedState = Math.clamp(hoistedState, 0.0f, 1.0f);
        this.method_5431();
    }

    public float getHoistedTargetState() {
        return Math.clamp(this.hoistedTargetState, 0.0f, 1.0f);
    }

    public void setHoistedTargetState(float hoistedTargetState) {
        this.hoistedTargetState = Math.clamp(hoistedTargetState, 0.0f, 1.0f);
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
        }
    }

    public int getFlagPoleCount() {
        if (this.method_10997() == null) {
            return 0;
        }
        return FlagPoleBlock.getFlagPoleBlockCount(this.method_10997(), this.method_11016());
    }

    @Nullable
    public class_2338 getTopBlockPos() {
        if (this.method_10997() == null) {
            return null;
        }
        return FlagPoleBlock.getTopBlockPos((class_1936)this.method_10997(), this.method_11016());
    }

    public boolean isHoistStateMoving() {
        return this.getHoistedState() != this.getHoistedTargetState() && this.getHoistedState() > 0.0f;
    }

    @Nullable
    public class_2338 getFlagPos() {
        if (this.method_10997() == null) {
            return null;
        }
        List<class_2338> connectedFlagPoleBlocks = FlagPoleBlock.connectedFlagPoleBlocks(this.field_11863, this.field_11867);
        if (connectedFlagPoleBlocks.isEmpty()) {
            return null;
        }
        int getFlagY = class_3532.method_48781((float)this.getHoistedState(), (int)connectedFlagPoleBlocks.getFirst().method_10264(), (int)connectedFlagPoleBlocks.getLast().method_10264());
        return new class_2338(this.method_11016().method_10263(), getFlagY, this.method_11016().method_10260());
    }

    private void modifyTargetHoistedState(class_1937 world, class_2338 pos) {
        if (!world.method_8393(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()))) {
            return;
        }
        class_2338 basePos = FlagPoleBlock.getBaseBlockPos(world, pos);
        if (basePos == null) {
            return;
        }
        float redstonePower = world.method_49804(basePos);
        float normalizedHeight = redstonePower / 15.0f;
        if (this.getHoistedState() == normalizedHeight) {
            return;
        }
        this.setHoistedTargetState(normalizedHeight);
        this.method_5431();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14178().method_14128(this.method_11016());
        }
    }

    public boolean dropFlagInventory(class_1657 player) {
        if (this.method_10997() == null) {
            return false;
        }
        if (this.isHoisted()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"chat.pulchra-occultorum.flag_still_hoisted"), true);
            return false;
        }
        if (this.getFlagInventory().method_5442()) {
            return false;
        }
        if (this.getBaseBlockPos() == null) {
            return false;
        }
        this.syncedInventoryModification(inventory -> {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.getBaseBlockPos().method_10084().method_10076(1), (class_1263)inventory);
            inventory.method_5441(0);
        });
        this.method_10997().method_8396(null, this.method_11016(), class_3417.field_34375, class_3419.field_15245, 1.0f, 0.7f);
        return true;
    }

    public void addOrReplaceFlagItemStack(class_1657 user, class_1799 newStack) {
        this.dropFlagInventory(user);
        this.syncedInventoryModification(inventory -> inventory.method_5447(0, newStack));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return this.method_38244(registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545("hoisted")) {
            this.setHoisted(nbt.method_10577("hoisted"));
        }
        if (nbt.method_10545("hoisted_state")) {
            this.setHoistedState(Math.clamp(nbt.method_10583("hoisted_state"), 0.0f, 1.0f));
        }
        if (nbt.method_10545("hoisted_target_state")) {
            this.setHoistedTargetState(Math.clamp(nbt.method_10583("hoisted_target_state"), 0.0f, 1.0f));
        }
        if (nbt.method_10545("saved_flags")) {
            this.flagInventory.method_7659(nbt.method_10554("saved_flags", 10), registryLookup);
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("hoisted", this.isHoisted());
        nbt.method_10548("hoisted_state", this.getHoistedState());
        nbt.method_10548("hoisted_target_state", this.getHoistedTargetState());
        nbt.method_10566("saved_flags", (class_2520)this.flagInventory.method_7660(registryLookup));
        class_2350 testD = class_2350.field_11043;
        nbt.method_10582("test", testD.method_15434());
    }
}

