/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.block.entity;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_4076;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.shirojr.pulchra_occultorum.PulchraOccultorum;
import net.shirojr.pulchra_occultorum.init.BlockEntities;
import net.shirojr.pulchra_occultorum.init.Blocks;
import net.shirojr.pulchra_occultorum.init.Tags;
import net.shirojr.pulchra_occultorum.network.packet.SpotlightSoundPacket;
import net.shirojr.pulchra_occultorum.screen.handler.SpotlightLampScreenHandler;
import net.shirojr.pulchra_occultorum.util.ShapeUtil;
import net.shirojr.pulchra_occultorum.util.SoundOrigin;
import net.shirojr.pulchra_occultorum.util.boilerplate.AbstractTickingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class SpotlightLampBlockEntity
extends AbstractTickingBlockEntity
implements ExtendedScreenHandlerFactory<Data>,
SoundOrigin {
    public static final float MAX_TURNING_SPEED = 0.7f;
    public static final float MIN_PITCH_RANGE = -90.0f;
    public static final float MAX_PITCH_RANGE = 50.0f;
    public static final float MIN_YAW_RANGE = -180.0f;
    public static final float MAX_YAW_RANGE = 180.0f;
    private ShapeUtil.Position rotation;
    private ShapeUtil.Position targetRotation;
    private int strength = 0;
    private float speed = 0.0f;
    private boolean isRotating = false;
    private boolean isSilent = false;
    private class_1277 inventory = new class_1277(1);

    public SpotlightLampBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.SPOTLIGHT_LAMP_BLOCK_ENTITY, pos, state);
        this.rotation = new ShapeUtil.Position(0, 0);
        this.targetRotation = new ShapeUtil.Position(0, 0);
    }

    public Data createData() {
        return new Data((Integer)this.method_11010().method_11654((class_2769)class_2741.field_12511), this.getRotation(), this.getTargetRotation(), this.method_11016(), this.getSpeed());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SpotlightLampBlockEntity blockEntity) {
        boolean isDampened;
        blockEntity.incrementTick(false);
        int powerFromBase = SpotlightLampBlockEntity.getPowerFromBase(world, pos, blockEntity);
        if (powerFromBase != blockEntity.getStrength()) {
            blockEntity.setStrength(powerFromBase);
        }
        if ((isDampened = SpotlightLampBlockEntity.isDampened(world, pos)) && !blockEntity.isSilent()) {
            blockEntity.setSilent(true);
        } else if (!isDampened && blockEntity.isSilent()) {
            blockEntity.setSilent(false);
        }
        if (world.method_8608()) {
            return;
        }
        if (blockEntity.getStrength() <= 0) {
            blockEntity.setSpeed(0.0f);
        }
        blockEntity.rotationHandling();
        boolean changeSoundState = false;
        if (blockEntity.isRotating) {
            if (blockEntity.getRotation().equals(blockEntity.getTargetRotation()) || blockEntity.getSpeed() <= 0.0f) {
                changeSoundState = true;
                blockEntity.isRotating = false;
            }
        } else if (!blockEntity.getRotation().equals(blockEntity.getTargetRotation()) && blockEntity.getSpeed() > 0.0f) {
            changeSoundState = true;
            blockEntity.isRotating = true;
        }
        if (changeSoundState) {
            for (class_3222 player : PlayerLookup.tracking((class_2586)blockEntity)) {
                new SpotlightSoundPacket(pos, blockEntity.isRotating).sendPacket(player);
            }
        }
    }

    private void rotationHandling() {
        ShapeUtil.Position targetRotation;
        ShapeUtil.Position rotation = this.getRotation();
        if (rotation.equals(targetRotation = this.getTargetRotation())) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        float newX = rotation.getX() + this.getSpeed();
        float newY = rotation.getY() + this.getSpeed();
        if (newX < targetRotation.getX()) {
            newX = Math.min(rotation.getX() + this.getSpeed(), targetRotation.getX());
        }
        if (newX > targetRotation.getX()) {
            newX = Math.max(rotation.getX() - this.getSpeed(), targetRotation.getX());
        }
        if (newY < targetRotation.getY()) {
            newY = Math.min(rotation.getY() + this.getSpeed(), targetRotation.getY());
        }
        if (newY > targetRotation.getY()) {
            newY = Math.max(rotation.getY() - this.getSpeed(), targetRotation.getY());
        }
        this.setRotation(new ShapeUtil.Position(newX, newY));
    }

    private static int getPowerFromBase(class_1937 world, class_2338 originalPos, SpotlightLampBlockEntity blockEntity) {
        if (!world.method_8393(class_4076.method_18675((int)originalPos.method_10263()), class_4076.method_18675((int)originalPos.method_10260()))) {
            return 0;
        }
        class_2338.class_2339 posWalker = originalPos.method_25503();
        do {
            posWalker.method_10098(class_2350.field_11033);
        } while (world.method_8320((class_2338)posWalker).method_26164(Tags.Blocks.SENDS_UPDATE_POWER_VERTICALLY));
        posWalker.method_10098(class_2350.field_11036);
        class_2680 baseBlockState = world.method_8320((class_2338)posWalker);
        int receivedPower = world.method_49804(posWalker.method_10062());
        if (world.method_8320(originalPos).method_28498((class_2769)class_2741.field_12511) && (Integer)world.method_8320(originalPos).method_11654((class_2769)class_2741.field_12511) != receivedPower && !world.method_8608()) {
            world.method_8492(originalPos, (class_2248)Blocks.SPOTLIGHT_LAMP, (class_2338)posWalker);
        }
        return receivedPower;
    }

    public static boolean isDampened(class_1937 world, class_2338 originalPos) {
        class_2338.class_2339 posWalker = originalPos.method_25503();
        do {
            posWalker.method_10098(class_2350.field_11033);
        } while (world.method_8320((class_2338)posWalker).method_26164(Tags.Blocks.SENDS_UPDATE_POWER_VERTICALLY));
        class_2680 baseState = world.method_8320(posWalker.method_10062());
        return baseState.method_26164(class_3481.field_15481) || baseState.method_26164(class_3481.field_15479);
    }

    public class_1799 getColorStack() {
        if (this.inventory.method_5442()) {
            return class_1799.field_8037;
        }
        return this.inventory.method_5438(0);
    }

    public void setColorStack(class_1799 stack) {
        this.inventory.method_5447(0, stack.method_46651(1));
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public void clearInventory(boolean dropInventory, class_2338 spawnPos) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (!this.getColorStack().method_7960() && dropInventory) {
            class_1264.method_5449((class_1937)serverWorld, (double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), (class_1799)this.getColorStack());
        }
        this.setColorStack(class_1799.field_8037);
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public ShapeUtil.Position getRotation() {
        return this.rotation;
    }

    public void setRotation(ShapeUtil.Position rotation) {
        this.rotation = rotation;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public ShapeUtil.Position getTargetRotation() {
        return this.targetRotation;
    }

    public void setTargetRotation(Supplier<ShapeUtil.Position> targetRotationConsumer) {
        this.targetRotation = targetRotationConsumer.get();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public void setSilent(boolean silent) {
        this.isSilent = silent;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.isRotating) {
                PlayerLookup.tracking((class_2586)this).forEach(serverPlayer -> new SpotlightSoundPacket(this.method_11016(), !silent).sendPacket((class_3222)serverPlayer));
            }
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = new class_1277(1);
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)registryLookup);
        this.speed = nbt.method_10583("speed");
        class_2487 rotationNbt = nbt.method_10562("rotation");
        class_2487 targetRotationNbt = nbt.method_10562("target_rotation");
        this.rotation = ShapeUtil.Position.fromNbt(rotationNbt);
        this.targetRotation = ShapeUtil.Position.fromNbt(targetRotationNbt);
        if (nbt.method_10545("silent")) {
            this.setSilent(nbt.method_10577("silent"));
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, (class_2371)this.inventory.method_54454(), (class_7225.class_7874)registryLookup);
        nbt.method_10548("speed", this.getSpeed());
        class_2487 rotationNbt = new class_2487();
        class_2487 targetRotationNbt = new class_2487();
        this.rotation.toNbt(rotationNbt);
        this.targetRotation.toNbt(targetRotationNbt);
        nbt.method_10566("rotation", (class_2520)rotationNbt);
        nbt.method_10566("target_rotation", (class_2520)targetRotationNbt);
        nbt.method_10556("silent", this.isSilent());
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public Data getScreenOpeningData(class_3222 player) {
        return this.createData();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SpotlightLampScreenHandler(syncId, playerInventory, this.createData());
    }

    @Override
    public String getUniqueId() {
        return String.valueOf(this.hashCode());
    }

    @Override
    public class_1937 getSoundOriginWorld() {
        return this.method_10997();
    }

    @Override
    public class_243 getSoundPos() {
        return this.method_11016().method_46558();
    }

    @Override
    @Nullable
    public class_243 getSoundOriginVelocity() {
        return null;
    }

    @Override
    public boolean stoppedExisting() {
        return this.method_11015();
    }

    public record Data(int strength, ShapeUtil.Position rotation, ShapeUtil.Position targetRotation, class_2338 pos, float speed) implements class_8710
    {
        public static final class_8710.class_9154<Data> IDENTIFIER = new class_8710.class_9154(PulchraOccultorum.getId("spotlight_lamp_data"));
        public static final class_9139<class_9129, Data> CODEC = class_9139.method_56906((class_9139)class_9135.field_49675, Data::strength, ShapeUtil.Position.CODEC_POSITION, Data::rotation, ShapeUtil.Position.CODEC_POSITION, Data::targetRotation, (class_9139)class_2338.field_48404, Data::pos, (class_9139)class_9135.field_48552, Data::speed, Data::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return IDENTIFIER;
        }
    }
}

