/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.block.entity.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2506;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4275;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.shirojr.pulchra_occultorum.PulchraOccultorum;
import net.shirojr.pulchra_occultorum.block.entity.SpotlightLampBlockEntity;
import net.shirojr.pulchra_occultorum.util.ArgbHelper;
import net.shirojr.pulchra_occultorum.util.RenderLayers;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SpotlightLampBlockEntityRenderer<T extends SpotlightLampBlockEntity>
implements class_827<T> {
    private final List<class_630> modelParts = new ArrayList<class_630>();
    private final class_630 lamp;
    private final class_630 horizontal;
    private final class_630 rotator;
    private final class_630 blades;

    public SpotlightLampBlockEntityRenderer(class_630 root) {
        this.lamp = root.method_32086("lamp");
        this.horizontal = this.lamp.method_32086("horizontal");
        this.rotator = this.horizontal.method_32086("rotator");
        this.blades = this.rotator.method_32086("blades");
        this.modelParts.addAll(List.of(this.lamp, this.horizontal, this.rotator, this.blades));
    }

    public void render(T blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1921[] layers;
        this.rotator.field_3654 = ((SpotlightLampBlockEntity)blockEntity).getRotation().getY() * ((float)Math.PI / 180);
        this.horizontal.field_3675 = ((SpotlightLampBlockEntity)blockEntity).getRotation().getX() * ((float)Math.PI / 180);
        matrices.method_22903();
        matrices.method_22904(0.5, 1.5, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        if (blockEntity.method_11010().method_28498((class_2769)class_2741.field_12481)) {
            int deg = 0;
            switch ((class_2350)blockEntity.method_11010().method_11654((class_2769)class_2741.field_12481)) {
                case field_11034: {
                    deg = 90;
                    break;
                }
                case field_11035: {
                    deg = 180;
                    break;
                }
                case field_11039: {
                    deg = 270;
                }
            }
            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)deg));
        }
        this.lamp.method_22698(matrices, vertexConsumers.getBuffer(this.getRenderLayer(blockEntity)), light, overlay);
        matrices.method_22903();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        matrices.method_22904(0.0, 0.95, 0.0);
        float height = ((SpotlightLampBlockEntity)blockEntity).getStrength() * 2;
        float side = 1.5f * height;
        Quaternionf rotation = new Quaternionf();
        float additionalPitchForBeam = (float)Math.toRadians(270.0);
        Quaternionf pitchRotation = new Quaternionf().rotateAxis(this.rotator.field_3654 + additionalPitchForBeam, 1.0f, 0.0f, 0.0f);
        Quaternionf yawRotation = new Quaternionf().rotateAxis(this.horizontal.field_3675, 0.0f, 1.0f, 0.0f);
        yawRotation.mul((Quaternionfc)pitchRotation, rotation);
        matrices.method_22907(rotation);
        matrices.method_22904(0.0, 0.25, 0.0);
        class_1799 colorStack = SpotlightLampBlockEntityRenderer.hasStackWithColor(blockEntity);
        if (colorStack != null && SpotlightLampBlockEntityRenderer.getStainable(colorStack) != null) {
            class_1747 blockItem;
            matrices.method_22903();
            class_1792 class_17922 = colorStack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2506) {
                matrices.method_22905(1.2f, 0.2f, 1.2f);
                matrices.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                matrices.method_46416(0.0f, 0.0f, 1.0f);
            } else {
                matrices.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                matrices.method_46416(0.0f, 0.0f, 0.2f);
                matrices.method_22905(0.6f, 0.6f, 1.7f);
            }
            class_310.method_1551().method_1480().method_23178(colorStack, class_811.field_4319, light, overlay, matrices, vertexConsumers, blockEntity.method_10997(), (int)blockEntity.method_11016().method_10063());
            matrices.method_22909();
        }
        if (((SpotlightLampBlockEntity)blockEntity).getStrength() <= 0) {
            matrices.method_22909();
            matrices.method_22909();
            return;
        }
        Vector3f a = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f b = new Vector3f(side / 2.0f, height, side / 2.0f);
        Vector3f c = new Vector3f(-side / 2.0f, height, side / 2.0f);
        Vector3f d = new Vector3f(-side / 2.0f, height, -side / 2.0f);
        Vector3f e = new Vector3f(side / 2.0f, height, -side / 2.0f);
        class_4587.class_4665 entry = matrices.method_23760();
        int primColor = class_5253.class_5254.method_59554((float)0.2f, (float)1.0f, (float)1.0f, (float)0.7f);
        int secColor = class_5253.class_5254.method_59554((float)0.0f, (float)1.0f, (float)0.6f, (float)0.3f);
        class_4275 stainable = SpotlightLampBlockEntityRenderer.getStainable(colorStack);
        if (stainable != null) {
            int argbFromItem = stainable.method_10622().method_7787();
            ArgbHelper primArgb = new ArgbHelper(argbFromItem).setBrightness(0.5f).setAlpha(0.6f);
            ArgbHelper secArgb = new ArgbHelper(argbFromItem).setBrightness(0.2f).setAlpha(0.001f);
            primColor = primArgb.getArgb();
            secColor = secArgb.getArgb();
        }
        for (class_1921 layer : layers = new class_1921[]{RenderLayers.SPOTLIGHT_LAMP_RAY}) {
            class_4588 vertexConsumer = vertexConsumers.getBuffer(layer);
            vertexConsumer.method_61032(entry, a).method_39415(primColor);
            vertexConsumer.method_61032(entry, b).method_39415(secColor);
            vertexConsumer.method_61032(entry, c).method_39415(secColor);
            vertexConsumer.method_61032(entry, a).method_39415(primColor);
            vertexConsumer.method_61032(entry, c).method_39415(secColor);
            vertexConsumer.method_61032(entry, d).method_39415(secColor);
            vertexConsumer.method_61032(entry, a).method_39415(primColor);
            vertexConsumer.method_61032(entry, d).method_39415(secColor);
            vertexConsumer.method_61032(entry, e).method_39415(secColor);
            vertexConsumer.method_61032(entry, a).method_39415(primColor);
            vertexConsumer.method_61032(entry, e).method_39415(secColor);
            vertexConsumer.method_61032(entry, b).method_39415(secColor);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        matrices.method_22909();
        matrices.method_22909();
    }

    private class_1921 getRenderLayer(T blockEntity) {
        String texturePath = this.isLit(blockEntity) ? "textures/entity/spotlight_lamp.png" : "textures/entity/spotlight_lamp_off.png";
        return class_1921.method_23576((class_2960)PulchraOccultorum.getId(texturePath));
    }

    private boolean isLit(T blockEntity) {
        class_2680 state = blockEntity.method_11010();
        if (!state.method_28498((class_2769)class_2741.field_12511)) {
            return false;
        }
        return (Integer)state.method_11654((class_2769)class_2741.field_12511) > 0;
    }

    @Nullable
    private static class_1799 hasStackWithColor(SpotlightLampBlockEntity blockEntity) {
        if (blockEntity.getColorStack().method_7960()) {
            return null;
        }
        class_1792 class_17922 = blockEntity.getColorStack().method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return null;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (!(blockItem.method_7711() instanceof class_4275)) {
            return null;
        }
        return blockEntity.getColorStack();
    }

    @Nullable
    public static class_4275 getStainable(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return null;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2248 class_22482 = blockItem.method_7711();
        if (!(class_22482 instanceof class_4275)) {
            return null;
        }
        class_4275 stainable = (class_4275)class_22482;
        return stainable;
    }

    public int method_33893() {
        return 256;
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 lamp = modelPartData.method_32117("lamp", class_5606.method_32108().method_32101(0, 12).method_32098(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 horizontal = lamp.method_32117("horizontal", class_5606.method_32108().method_32101(27, 0).method_32098(2.0f, -10.0f, -1.0f, 1.0f, 6.0f, 2.0f, new class_5605(0.0f)).method_32101(0, 0).method_32098(-3.0f, -10.0f, -1.0f, 1.0f, 6.0f, 2.0f, new class_5605(0.0f)).method_32101(16, 14).method_32098(-3.0f, -4.0f, -2.0f, 6.0f, 1.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 rotator = horizontal.method_32117("rotator", class_5606.method_32108().method_32101(0, 14).method_32098(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 8.0f, new class_5605(0.0f)).method_32101(24, 19).method_32098(-3.0f, -3.0f, -5.0f, 6.0f, 6.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-9.0f, (float)0.0f));
        class_5610 blades = rotator.method_32117("blades", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)3.0f, (float)-4.0f));
        class_5610 cube_r1 = blades.method_32117("cube_r1", class_5606.method_32108().method_32101(0, 7).method_32098(-5.0f, 0.0f, -6.0f, 10.0f, 0.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        class_5610 cube_r2 = blades.method_32117("cube_r2", class_5606.method_32108().method_32101(0, 19).method_32098(0.0f, -5.0f, -6.0f, 0.0f, 10.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32091((float)3.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        class_5610 cube_r3 = blades.method_32117("cube_r3", class_5606.method_32108().method_32101(0, 0).method_32098(-5.0f, 0.0f, -6.0f, 10.0f, 0.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)-6.0f, (float)-1.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        class_5610 cube_r4 = blades.method_32117("cube_r4", class_5606.method_32108().method_32101(14, 19).method_32098(0.0f, -5.0f, -6.0f, 0.0f, 10.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32091((float)-3.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }
}

