/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.shirojr.pulchra_occultorum.init.SoundEvents;
import net.shirojr.pulchra_occultorum.network.packet.UnicycleSoundPacket;
import net.shirojr.pulchra_occultorum.util.SoundOrigin;
import net.shirojr.pulchra_occultorum.util.boilerplate.AbstractRideableEntity;
import org.jetbrains.annotations.Nullable;

public class UnicycleEntity
extends AbstractRideableEntity
implements SoundOrigin {
    public static final float JUMP_STRENGTH = 1.5f;
    public static final float INTERVAL_SPEED = 0.25f;
    private boolean hasMovementInputs = false;
    private static final class_2940<Float> LEFT_IMPORTANT_STATE = class_2945.method_12791(UnicycleEntity.class, (class_2941)class_2943.field_13320);
    @Nullable
    private DirectionInput[] directionInputs = new DirectionInput[]{null, null, null};

    public UnicycleEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 5.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LEFT_IMPORTANT_STATE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void method_5773() {
        super.method_5773();
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        new UnicycleSoundPacket(this.method_5628(), true).sendPacket(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        new UnicycleSoundPacket(this.method_5628(), false).sendPacket(player);
    }

    public DirectionInput[] getDirectionInputs() {
        return this.directionInputs;
    }

    public void setDirectionInputs(@Nullable DirectionInput inputLeft, @Nullable DirectionInput inputRight) {
        this.setDirectionInputs(new DirectionInput[]{inputLeft, inputRight});
    }

    public void setDirectionInputs(@Nullable DirectionInput[] input) {
        this.directionInputs = input;
    }

    public float getLeftImportantState() {
        return ((Float)this.field_6011.method_12789(LEFT_IMPORTANT_STATE)).floatValue();
    }

    public void setLeftImportantState(float state) {
        state = class_3532.method_15363((float)state, (float)-1.0f, (float)1.0f);
        this.field_6011.method_12778(LEFT_IMPORTANT_STATE, (Object)Float.valueOf(state));
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return SoundEvents.UNICYCLE_CLANK;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SoundEvents.UNICYCLE_CLANK;
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        class_243 controlledMovement;
        float sideways = controllingPlayer.field_6212 * 0.2f;
        float forward = controllingPlayer.field_6250;
        float up = controllingPlayer.field_6227;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        this.setMovedByInputs((controlledMovement = new class_243((double)sideways, (double)up, (double)forward)).method_1033() > 0.0);
        return controlledMovement;
    }

    public boolean isMovedByInput() {
        return this.hasMovementInputs;
    }

    public void setMovedByInputs(boolean usesInputsToMove) {
        this.hasMovementInputs = usesInputsToMove;
    }

    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        this.method_5710(controllingPlayer.method_36454(), controllingPlayer.method_36455() * 0.5f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (!this.method_5787()) {
            return;
        }
        this.move(movementInput);
    }

    @Override
    public void method_38785() {
        super.method_38785();
        this.setInAir(false);
    }

    protected void move(class_243 movementInput) {
        float jumpStrength;
        float speed = 0.0f;
        DirectionInput[] input = this.getDirectionInputs();
        DirectionInput left = input[0];
        DirectionInput right = input[1];
        DirectionInput jump = input[2];
        if (left == null && right == null && jump == null) {
            return;
        }
        boolean goesForward = false;
        boolean goesBackward = false;
        boolean jumped = false;
        if (left != null) {
            goesForward = left.equals((Object)DirectionInput.LEFT) && this.getLeftImportantState() > 0.0f;
            boolean bl = goesBackward = left.equals((Object)DirectionInput.LEFT) && this.getLeftImportantState() < 0.0f;
        }
        if (right != null) {
            goesForward = right.equals((Object)DirectionInput.RIGHT) && this.getLeftImportantState() < 0.0f;
            boolean bl = goesBackward = right.equals((Object)DirectionInput.RIGHT) && this.getLeftImportantState() > 0.0f;
        }
        if (jump != null) {
            boolean bl = jumped = jump.equals((Object)DirectionInput.JUMP) && !this.isInAir();
        }
        if (goesForward) {
            speed = 0.2f;
        }
        if (goesBackward) {
            speed = -0.2f;
        }
        if (speed == 0.0f && !jumped) {
            return;
        }
        if (this.method_5799()) {
            speed *= 0.15f;
        }
        this.field_6007 = true;
        if (this.isInAir()) {
            return;
        }
        float zDirection = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
        float xDirection = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
        float f = jumpStrength = jumped ? this.method_56994(1.5f) : 0.0f;
        if (jumpStrength > 0.0f) {
            this.setInAir(true);
            speed += 0.8f;
        }
        this.method_60491(new class_243((double)(-speed * zDirection), (double)jumpStrength, (double)(speed * xDirection)));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        float computedFallDamage = (float)this.method_23329(fallDistance, damageMultiplier) * 0.8f;
        this.method_5783(this.getLandingSound(), 1.2f, 0.9f);
        if (computedFallDamage > 0.0f) {
            this.method_23328();
            for (class_1297 passenger : this.method_5685()) {
                class_1309 livingEntity;
                if (!(passenger instanceof class_1309) || (livingEntity = (class_1309)passenger).method_5864().method_20210(class_3483.field_42971)) continue;
                livingEntity.method_5643(damageSource, computedFallDamage);
            }
            return true;
        }
        return false;
    }

    public class_3414 getLandingSound() {
        return SoundEvents.UNICYCLE_LAND;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_30949(class_1297 other) {
        return UnicycleEntity.canCollide((class_1297)this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_30948() {
        return true;
    }

    @Override
    public String getUniqueId() {
        return this.method_5667().toString();
    }

    @Override
    public class_1937 getSoundOriginWorld() {
        return this.method_37908();
    }

    @Override
    public class_243 getSoundPos() {
        return this.method_19538();
    }

    @Override
    @Nullable
    public class_243 getSoundOriginVelocity() {
        return this.method_18798();
    }

    @Override
    public boolean stoppedExisting() {
        return this.method_31481() || this.method_29504();
    }

    public static enum DirectionInput {
        LEFT("input_left"),
        RIGHT("input_right"),
        JUMP("input_jump");

        private final String name;

        private DirectionInput(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static DirectionInput fromString(String name) {
            for (DirectionInput entry : DirectionInput.values()) {
                if (!entry.getName().equals(name)) continue;
                return entry;
            }
            return null;
        }
    }
}

