/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.mixin;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1355;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_8152;
import net.minecraft.class_9460;
import net.minecraft.class_9817;
import net.shirojr.pulchra_occultorum.item.WhipItem;
import net.shirojr.pulchra_occultorum.network.packet.MobEntitySyncPacket;
import net.shirojr.pulchra_occultorum.util.Fright;
import net.shirojr.pulchra_occultorum.util.LoggerUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1308.class})
public abstract class MobEntityMixin
extends class_1309
implements class_9460,
class_9817,
class_8152,
Fright {
    @Shadow
    @Final
    protected class_1355 field_6201;
    @Unique
    private int frightenedTicks = 0;
    @Unique
    @Nullable
    private UUID aggressorUuid = null;

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("aggressor")) {
            this.aggressorUuid = nbt.method_25926("aggressor");
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.aggressorUuid == null) {
            nbt.method_10551("aggressor");
        } else {
            nbt.method_25927("aggressor", this.aggressorUuid);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/mob/MobEntity;initGoals()V")})
    private void addWhipFleeingGoal(CallbackInfo ci) {
        class_1308 fleeingEntity = (class_1308)this;
        if (!(fleeingEntity instanceof class_1314)) {
            return;
        }
        class_1314 pathAwareEntity = (class_1314)fleeingEntity;
        this.field_6201.method_6277(2, new WhipItem.WhipUsedGoal<class_1309>(pathAwareEntity, this.pulchraOccultorum$getAggressor(), class_1309.class, 30.0f, 5.0, 10.0));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void addFrightenedTickHandling(CallbackInfo ci) {
        class_1308 fleeingEntity = (class_1308)this;
        if (fleeingEntity.method_37908().method_8608()) {
            return;
        }
        int frightenedTicksLeft = this.pulchraOccultorum$getFrightenedTicksLeft();
        if (frightenedTicksLeft < 1) {
            return;
        }
        this.pulchraOccultorum$setFrightenedTicksLeft(--frightenedTicksLeft);
        LoggerUtil.devLogger("Frightened: %s | for %s more ticks".formatted(fleeingEntity, frightenedTicksLeft));
    }

    @Override
    public int pulchraOccultorum$getFrightenedTicksLeft() {
        return this.frightenedTicks;
    }

    @Override
    public void pulchraOccultorum$setFrightenedTicksLeft(int ticks) {
        this.frightenedTicks = ticks;
        if (this.method_37908().method_8608()) {
            return;
        }
        new MobEntitySyncPacket(this.method_5628(), this.pulchraOccultorum$getFrightenedTicksLeft()).sendPacket(PlayerLookup.tracking((class_1297)this));
    }

    @Override
    public boolean pulchraOccultorum$isFrightened() {
        return this.pulchraOccultorum$getFrightenedTicksLeft() > 0;
    }

    @Override
    @Nullable
    public class_1309 pulchraOccultorum$getAggressor() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1297 entity = serverWorld.method_14190(this.aggressorUuid);
        if (!(entity instanceof class_1309)) {
            return null;
        }
        class_1309 livingEntity = (class_1309)entity;
        return livingEntity;
    }

    @Override
    public void pulchraOccultorum$setAggressor(@Nullable class_1309 aggressorEntity) {
        this.aggressorUuid = aggressorEntity == null ? null : aggressorEntity.method_5667();
    }
}

