/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.shirojr.pulchra_occultorum.PulchraOccultorum;
import net.shirojr.pulchra_occultorum.block.entity.SpotlightLampBlockEntity;
import net.shirojr.pulchra_occultorum.network.packet.HandlePositionPacket;
import net.shirojr.pulchra_occultorum.network.packet.SpotlightTextFieldPacket;
import net.shirojr.pulchra_occultorum.screen.handler.SpotlightLampScreenHandler;
import net.shirojr.pulchra_occultorum.screen.widget.ButtonScreenElement;
import net.shirojr.pulchra_occultorum.screen.widget.DragScreenElement;
import net.shirojr.pulchra_occultorum.screen.widget.SpotlightTextFieldWidget;
import net.shirojr.pulchra_occultorum.util.LoggerUtil;
import net.shirojr.pulchra_occultorum.util.ShapeUtil;
import org.jetbrains.annotations.Nullable;

public class SpotlightLampScreen
extends class_465<SpotlightLampScreenHandler> {
    private int prevX = -1;
    private int prevY = -1;
    private int originX = -1;
    private int originY = -1;
    private SpotlightTextFieldWidget pitch;
    private SpotlightTextFieldWidget yaw;
    private SpotlightTextFieldWidget speed;
    private List<class_342> textFields;
    private final List<DragScreenElement> dragScreenElementList = new ArrayList<DragScreenElement>();
    private final ButtonScreenElement submitButton = new ButtonScreenElement(PulchraOccultorum.getId("textures/gui/spotlight_input.png"), 135, 90, 9, 9, 187, 0, 0, 9, 20, () -> {
        float speed;
        float yaw;
        float pitch;
        try {
            pitch = Float.parseFloat(this.pitch.method_1882());
        }
        catch (Exception e) {
            pitch = ((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getTargetRotation().getY();
        }
        try {
            yaw = Float.parseFloat(this.yaw.method_1882());
        }
        catch (Exception e) {
            yaw = ((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getTargetRotation().getX();
        }
        try {
            speed = Float.parseFloat(this.speed.method_1882());
        }
        catch (Exception e) {
            speed = ((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getSpeed();
        }
        new SpotlightTextFieldPacket(((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().method_11016(), Optional.of(Float.valueOf(pitch)), Optional.of(Float.valueOf(yaw)), Optional.of(Float.valueOf(speed))).sendPacket();
        this.initScreenElementPositions();
    });

    public SpotlightLampScreen(SpotlightLampScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    protected void method_25426() {
        super.method_25426();
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        ShapeUtil.Square bigHandle = new ShapeUtil.Square(74, 66, 83, 75);
        ShapeUtil.Square smallHandle = new ShapeUtil.Square(159, 17, 165, 26);
        this.dragScreenElementList.add(new DragScreenElement("big_handle", false, 20, DragScreenElement.getShapeWithOffset(bigHandle, x, y), DragScreenElement.getShapeWithOffset(bigHandle, x, y), DragScreenElement.getPositionWithOffset(bigHandle.getSquareStart().add(-66.0f, -48.0f), x, y), DragScreenElement.getPositionWithOffset(bigHandle.getSquareEnd().add(66.0f, 48.0f), x, y), true));
        this.dragScreenElementList.add(new DragScreenElement("small_handle", false, 20, DragScreenElement.getShapeWithOffset(smallHandle, x, y), DragScreenElement.getShapeWithOffset(smallHandle, x, y), DragScreenElement.getPositionWithOffset(smallHandle.getSquareStart().add(0.0f, 0.0f), x, y), DragScreenElement.getPositionWithOffset(smallHandle.getSquareEnd().add(0.0f, 98.0f), x, y), true));
        this.initScreenElementPositions();
        Predicate<String> inputFormat = text -> text.matches("-?\\d*(\\.\\d*)?");
        int textFieldInputX = this.field_22789 / 2 + 142;
        int textFieldInputY = this.field_22790 / 2 - 66;
        this.pitch = new SpotlightTextFieldWidget(this.field_22793, textFieldInputX, textFieldInputY, 80, 20, (class_2561)class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.text.pitch"));
        this.pitch.method_1852(String.valueOf(((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getTargetRotation().getY()));
        this.yaw = new SpotlightTextFieldWidget(this.field_22793, textFieldInputX, textFieldInputY + 25, 80, 20, (class_2561)class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.text.yaw"));
        this.yaw.method_1852(String.valueOf(((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getTargetRotation().getX()));
        this.speed = new SpotlightTextFieldWidget(this.field_22793, textFieldInputX, textFieldInputY + 50, 80, 20, (class_2561)class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.text.speed"));
        this.speed.method_1852(String.valueOf(((SpotlightLampScreenHandler)this.method_17577()).getBlockEntity().getSpeed()));
        this.textFields = List.of(this.pitch, this.yaw, this.speed);
        this.textFields.forEach(widget -> {
            widget.method_1880(12);
            widget.method_1890(inputFormat);
            this.method_25429((class_364)widget);
        });
        this.submitButton.moveTo(textFieldInputX + 90, textFieldInputY + 75);
    }

    private void initScreenElementPositions() {
        DragScreenElement smallHandle;
        SpotlightLampBlockEntity blockEntity = ((SpotlightLampScreenHandler)this.field_2797).getBlockEntity();
        DragScreenElement bigHandle = DragScreenElement.fromList("big_handle", this.dragScreenElementList);
        if (bigHandle != null) {
            float normalizedYaw = (blockEntity.getTargetRotation().getX() - -180.0f) / 360.0f;
            float normalizedPitch = (blockEntity.getTargetRotation().getY() - -90.0f) / 140.0f;
            int yawOnScreen = (int)class_3532.method_16439((float)normalizedYaw, (float)bigHandle.getMinBoundary().getX(), (float)(bigHandle.getMaxBoundary().getX() - bigHandle.getShape().getWidth()));
            int pitchOnScreen = (int)class_3532.method_16439((float)normalizedPitch, (float)bigHandle.getMinBoundary().getY(), (float)(bigHandle.getMaxBoundary().getY() - bigHandle.getShape().getHeight()));
            bigHandle.getShape().moveSquareToTarget(yawOnScreen, pitchOnScreen);
        }
        if ((smallHandle = DragScreenElement.fromList("small_handle", this.dragScreenElementList)) != null) {
            float normalizedSpeed = blockEntity.getSpeed() / 0.7f;
            int speedOnScreen = (int)class_3532.method_16439((float)normalizedSpeed, (float)smallHandle.getMinBoundary().getY(), (float)(smallHandle.getMaxBoundary().getY() - smallHandle.getShape().getHeight()));
            smallHandle.getShape().moveSquareToTarget((int)smallHandle.getShape().getSquareStart().getX(), speedOnScreen);
        }
        int textFieldInputX = this.field_22789 / 2 + 142;
        int textFieldInputY = this.field_22790 / 2 - 66;
        this.submitButton.moveTo(textFieldInputX + 90, textFieldInputY + 75);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(PulchraOccultorum.getId("textures/gui/spotlight.png"), x, y, 0, 0, this.field_2792, this.field_2779);
        context.method_25302(PulchraOccultorum.getId("textures/gui/spotlight_input.png"), x + 185, y, 0, 0, 156, this.field_2779);
        DragScreenElement bigHandle = DragScreenElement.fromList("big_handle", this.dragScreenElementList);
        DragScreenElement smallHandle = DragScreenElement.fromList("small_handle", this.dragScreenElementList);
        if (bigHandle != null) {
            SpotlightLampScreen.renderScreenElement(bigHandle, context, 183, 0);
        }
        if (smallHandle != null) {
            SpotlightLampScreen.renderScreenElement(smallHandle, context, 176, 0);
        }
        this.submitButton.draw(context, false);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        SpotlightLampBlockEntity blockEntity = ((SpotlightLampScreenHandler)this.field_2797).getBlockEntity();
        int informationTextY = this.field_25268 + 123;
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        this.drawInformationText(context, "Pitch:", Float.valueOf(blockEntity.getRotation().getY()), this.field_25267, informationTextY);
        this.drawInformationText(context, "Yaw:", Float.valueOf(blockEntity.getRotation().getX()), this.field_25267, informationTextY += 10);
        this.drawInformationText(context, "Speed:", Float.valueOf(blockEntity.getSpeed()), this.field_25267, informationTextY += 10);
        int inputX = this.field_25267 + 185;
        int inputY = this.field_25268 + 16;
        context.method_51439(this.field_22793, class_2561.method_30163((String)"Input"), inputX, this.field_25268, 0x404040, false);
        this.drawInformationText(context, "Pitch:", null, inputX, inputY);
        this.drawInformationText(context, "Yaw:", null, inputX, inputY += 25);
        this.drawInformationText(context, "Speed:", null, inputX, inputY += 25);
    }

    private void drawInformationText(class_332 context, String display, @Nullable Float value, int x, int y) {
        int horizontalValueOffset = 40;
        class_2561 valueName = class_2561.method_30163((String)display);
        context.method_51439(this.field_22793, valueName, x, y, 0x404040, false);
        if (value != null) {
            class_2561 formattedValue = class_2561.method_30163((String)String.valueOf(value));
            context.method_51439(this.field_22793, formattedValue, x + horizontalValueOffset, y, 0x404040, false);
        }
    }

    private static void renderScreenElement(DragScreenElement element, class_332 context, int u, int v) {
        int pressedSpriteOffset = element.isPressed() ? v + 9 : v;
        context.method_25302(PulchraOccultorum.getId("textures/gui/spotlight.png"), (int)element.getShape().getSquareStart().getX(), (int)element.getShape().getSquareStart().getY(), u, pressedSpriteOffset, (int)element.getShape().getWidth(), (int)element.getShape().getHeight());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        for (DragScreenElement entry : this.dragScreenElementList) {
            if (entry.isPressed()) {
                entry.setHoveredTicks(0);
                continue;
            }
            if (!entry.getShape().isPositionInSquare(new ShapeUtil.Position(mouseX, mouseY))) {
                entry.setHoveredTicks(0);
                continue;
            }
            if (entry.getHoveredTicks() <= entry.getMaxTicksUntilToolTip()) continue;
            List<class_5250> lines = List.of(class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover1"), class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover2"), class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover3"));
            context.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY);
        }
        this.textFields.forEach(widget -> widget.method_25394(context, mouseX, mouseY, delta));
        if (this.submitButton.getHoveredTicks() >= this.submitButton.getTicksUntilToolTip()) {
            List<class_5250> lines = List.of(class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover_submit1"), class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover_submit2"), class_2561.method_43471((String)"screen.pulchra-occultorum.spotlight_lamp.hover_submit3"));
            context.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        this.initScreenElementPositions();
        this.method_25423(client, width, height);
        super.method_25410(client, width, height);
    }

    protected void method_37432() {
        super.method_37432();
        for (DragScreenElement entry : this.dragScreenElementList) {
            if (entry.canBeDoubleClicked()) {
                entry.setTicksAfterClicked(entry.getTicksAfterClicked() + 1);
            }
            if (entry.getTicksAfterClicked() > 5) {
                entry.setTicksAfterClicked(0);
                entry.setCanBeDoubleClicked(false);
            }
            entry.incrementHoverTicks(1);
        }
        if (this.submitButton.isHovered() && this.submitButton.getHoveredTicks() <= this.submitButton.getTicksUntilToolTip()) {
            this.submitButton.incrementHoverTicks();
        }
    }

    private void sendTargetRotationPacket(DragScreenElement entry, @Nullable Float x, @Nullable Float y) {
        new HandlePositionPacket(entry.getName(), ((SpotlightLampScreenHandler)this.field_2797).getBlockEntity().method_11016(), Optional.ofNullable(x), Optional.ofNullable(y)).sendPacket();
    }

    private void resetPosition(DragScreenElement element) {
        element.setToDefaultPosition();
        element.setCanBeDoubleClicked(false);
        this.sendTargetRotationPacket(element, Float.valueOf(element.getNormalized().getX()), Float.valueOf(element.getNormalized().getY()));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (DragScreenElement entry : this.dragScreenElementList) {
            if (!entry.getShape().isPositionInSquare(new ShapeUtil.Position((int)mouseX, (int)mouseY))) continue;
            entry.setPressed(true);
            this.prevX = this.originX = (int)mouseX;
            this.prevY = this.originY = (int)mouseY;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14962, (float)0.5f));
            break;
        }
        if (this.submitButton.isInShape((int)mouseX, (int)mouseY)) {
            this.submitButton.setHovered(true);
            this.submitButton.setHoveredTicks(0);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (DragScreenElement entry : this.dragScreenElementList) {
            if (!entry.isPressed()) continue;
            if (entry.getName().equals("big_handle")) {
                this.sendTargetRotationPacket(entry, Float.valueOf(entry.getNormalized().getX()), Float.valueOf(entry.getNormalized().getY()));
            }
            if (entry.getName().equals("small_handle")) {
                this.sendTargetRotationPacket(entry, null, Float.valueOf(entry.getNormalized().getY()));
            }
            this.prevX = -1;
            this.prevY = -1;
            entry.setPressed(false);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14962, (float)0.6f));
            if (!entry.canBeDoubleClicked()) {
                entry.setCanBeDoubleClicked(true);
                continue;
            }
            this.resetPosition(entry);
        }
        if (this.submitButton.isHovered()) {
            this.submitButton.setHovered(false);
            this.submitButton.run();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        for (DragScreenElement entry : this.dragScreenElementList) {
            if (!entry.isPressed()) continue;
            entry.setCanBeDoubleClicked(false);
            int draggedHorizontalDistance = (int)mouseX - this.prevX;
            int draggedVerticalDistance = (int)mouseY - this.prevY;
            if (class_437.method_25442()) {
                int distanceX = (int)(mouseX - (double)this.originX);
                int distanceY = (int)(mouseY - (double)this.originY);
                LoggerUtil.devLogger("distance X: %s | origin X: %s".formatted(distanceX, this.originX));
                LoggerUtil.devLogger("distance Y: %s | origin Y: %s".formatted(distanceY, this.originY + "\n"));
                if (Math.abs(distanceX) > Math.abs(distanceY)) {
                    draggedVerticalDistance = 0;
                    this.prevX = this.originX;
                } else {
                    draggedHorizontalDistance = 0;
                    this.prevY = this.originY;
                }
            }
            entry.getShape().moveElementWithinBoundaries(draggedHorizontalDistance, draggedVerticalDistance, entry.getMinBoundary(), entry.getMaxBoundary());
            this.prevX = (int)mouseX;
            this.prevY = (int)mouseY;
        }
        if (this.submitButton.isHovered() && !this.submitButton.isInShape((int)mouseX, (int)mouseY)) {
            this.submitButton.setHovered(false);
            this.submitButton.setHoveredTicks(0);
        } else if (!this.submitButton.isHovered() && this.submitButton.isInShape((int)mouseX, (int)mouseY)) {
            this.submitButton.setHovered(true);
        }
    }
}

