/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.sound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.shirojr.pulchra_occultorum.util.SoundOrigin;
import net.shirojr.pulchra_occultorum.util.boilerplate.AbstractDynamicSoundInstance;
import org.jetbrains.annotations.NotNull;

public class SoundManager {
    private static SoundManager instance;
    private final Map<String, List<class_1113>> activeSounds = new HashMap<String, List<class_1113>>();

    private SoundManager() {
    }

    public static SoundManager getInstance() {
        if (instance == null) {
            instance = new SoundManager();
        }
        return instance;
    }

    public void play(@NotNull SoundOrigin origin, class_1113 ... instances) {
        if (!this.activeSounds.containsKey(origin.getUniqueId())) {
            this.activeSounds.put(origin.getUniqueId(), new ArrayList());
        }
        List<class_1113> activeInstancesForEntity = this.activeSounds.get(origin.getUniqueId());
        for (class_1113 soundInstance : instances) {
            if (activeInstancesForEntity.contains(soundInstance)) continue;
            class_310.method_1551().method_1483().method_4873(soundInstance);
            activeInstancesForEntity.add(soundInstance);
        }
    }

    public void stop(@NotNull SoundOrigin origin, class_1113 ... instances) {
        List<class_1113> entriesForEntity = this.activeSounds.get(origin.getUniqueId());
        if (entriesForEntity == null) {
            return;
        }
        for (class_1113 soundInstance : instances) {
            if (!entriesForEntity.contains(soundInstance)) continue;
            if (soundInstance instanceof AbstractDynamicSoundInstance) {
                AbstractDynamicSoundInstance dynamicSoundInstance = (AbstractDynamicSoundInstance)soundInstance;
                dynamicSoundInstance.finishSoundInstance();
            } else {
                class_310.method_1551().method_1483().method_4870(soundInstance);
            }
            this.activeSounds.get(origin.getUniqueId()).remove(soundInstance);
        }
    }

    public void stopAll(@NotNull SoundOrigin origin) {
        List<class_1113> entriesForEntity = this.activeSounds.get(origin.getUniqueId());
        for (class_1113 soundInstance : entriesForEntity) {
            if (soundInstance instanceof AbstractDynamicSoundInstance) {
                AbstractDynamicSoundInstance dynamicSoundInstance = (AbstractDynamicSoundInstance)soundInstance;
                dynamicSoundInstance.finishSoundInstance();
                continue;
            }
            class_310.method_1551().method_1483().method_4870(soundInstance);
        }
        this.activeSounds.remove(origin.getUniqueId());
    }
}

