/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.util;

import net.minecraft.class_3532;

public class ArgbHelper {
    private final int argb;

    public ArgbHelper(int argb) {
        this.argb = argb;
    }

    public ArgbHelper(float normalizedAlpha, float normalizedRed, float normalizedGreen, float normalizedBlue) {
        int alpha = ArgbHelper.fullColorValue(normalizedAlpha);
        int red = ArgbHelper.fullColorValue(normalizedRed);
        int green = ArgbHelper.fullColorValue(normalizedGreen);
        int blue = ArgbHelper.fullColorValue(normalizedBlue);
        this.argb = alpha << 24 | red << 16 | green << 8 | blue;
    }

    public int getArgb() {
        return this.argb;
    }

    int getAlpha() {
        return this.argb >> 24 & 0xFF;
    }

    public ArgbHelper setAlpha(float normalized) {
        normalized = class_3532.method_15363((float)normalized, (float)0.0f, (float)1.0f);
        return new ArgbHelper(normalized, ArgbHelper.normalized(this.getRed()), ArgbHelper.normalized(this.getGreen()), ArgbHelper.normalized(this.getBlue()));
    }

    public int getRed() {
        return this.argb >> 16 & 0xFF;
    }

    public ArgbHelper setRed(float normalized) {
        normalized = class_3532.method_15363((float)normalized, (float)0.0f, (float)1.0f);
        return new ArgbHelper(ArgbHelper.normalized(this.getAlpha()), normalized, ArgbHelper.normalized(this.getGreen()), ArgbHelper.normalized(this.getBlue()));
    }

    public int getGreen() {
        return this.argb >> 8 & 0xFF;
    }

    public ArgbHelper setGreen(float normalized) {
        normalized = class_3532.method_15363((float)normalized, (float)0.0f, (float)1.0f);
        return new ArgbHelper(ArgbHelper.normalized(this.getAlpha()), ArgbHelper.normalized(this.getRed()), normalized, ArgbHelper.normalized(this.getBlue()));
    }

    public int getBlue() {
        return this.argb & 0xFF;
    }

    public ArgbHelper setBlue(float normalized) {
        normalized = class_3532.method_15363((float)normalized, (float)0.0f, (float)1.0f);
        return new ArgbHelper(ArgbHelper.normalized(this.getAlpha()), ArgbHelper.normalized(this.getRed()), ArgbHelper.normalized(this.getGreen()), normalized);
    }

    public ArgbHelper setBrightness(float factor) {
        factor = class_3532.method_15363((float)factor, (float)0.0f, (float)1.0f);
        int red = (int)Math.clamp((float)this.getRed() * factor, 0.0f, 255.0f);
        int green = (int)Math.clamp((float)this.getGreen() * factor, 0.0f, 255.0f);
        int blue = (int)Math.clamp((float)this.getBlue() * factor, 0.0f, 255.0f);
        return new ArgbHelper(ArgbHelper.normalized(this.getAlpha()), ArgbHelper.normalized(red), ArgbHelper.normalized(green), ArgbHelper.normalized(blue));
    }

    public static float normalized(int color) {
        return (float)color / 255.0f;
    }

    public static int fullColorValue(float normalized) {
        return Math.round(normalized * 255.0f);
    }

    public static int getARGB(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

