/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.util;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ShapeUtil {

    public static class Square {
        private Position squareStart;
        private Position squareEnd;
        public static class_9139<class_9129, Square> CODEC_SQUARE = class_9139.method_56435(Position.CODEC_POSITION, Square::getSquareStart, Position.CODEC_POSITION, Square::getSquareEnd, Square::new);

        public Square(Position posStart, Position posEnd) {
            this.squareStart = posStart;
            this.squareEnd = posEnd;
        }

        public Square(int startX, int startY, int endX, int endY) {
            this(new Position(startX, startY), new Position(endX, endY));
        }

        public Square(Position squareStart, int width, int height) {
            this.squareStart = squareStart;
            this.squareEnd = new Position(squareStart.x + (float)width, squareStart.y + (float)height);
        }

        public boolean isPositionInSquare(Position position) {
            return position.x >= this.getSquareStart().x && position.y >= this.getSquareStart().y && position.x <= this.getSquareEnd().x && position.y <= this.getSquareEnd().y;
        }

        public Position getSquareStart() {
            return this.squareStart;
        }

        public void setSquareStart(Position squareStart) {
            this.squareStart = new Position(squareStart.getX(), squareStart.getY());
        }

        public Position getSquareEnd() {
            return this.squareEnd;
        }

        public void setSquareEnd(Position squareEnd) {
            this.squareEnd = new Position(squareEnd.getX(), squareEnd.getY());
        }

        public float getWidth() {
            return class_3532.method_15379((float)(this.getSquareEnd().x - this.getSquareStart().x));
        }

        public float getHeight() {
            return class_3532.method_15379((float)(this.getSquareEnd().y - this.getSquareStart().y));
        }

        public float getBoundaryWidth() {
            return this.squareEnd.getX() - this.squareStart.getX();
        }

        public float getBoundaryHeight() {
            return this.squareEnd.getY() - this.squareStart.getY();
        }

        public void moveSquare(int x, int y) {
            this.moveSquareToTarget(this.getSquareStart().add(x, y));
        }

        public void moveElementWithinBoundaries(int x, int y, Position start, Position end) {
            float newStartX = this.getSquareStart().getX() + (float)x;
            float newStartY = this.getSquareStart().getY() + (float)y;
            float newEndX = this.getSquareEnd().getX() + (float)x;
            float newEndY = this.getSquareEnd().getY() + (float)y;
            if (newStartX < start.getX()) {
                newStartX = start.getX();
                newEndX = start.getX() + this.getWidth();
            }
            if (newStartY < start.getY()) {
                newStartY = start.getY();
                newEndY = start.getY() + this.getHeight();
            }
            if (newEndX > end.getX()) {
                newEndX = end.getX();
                newStartX = end.getX() - this.getWidth();
            }
            if (newEndY > end.getY()) {
                newEndY = end.getY();
                newStartY = end.getY() - this.getHeight();
            }
            this.getSquareStart().setX(newStartX);
            this.getSquareStart().setY(newStartY);
            this.getSquareEnd().setX(newEndX);
            this.getSquareEnd().setY(newEndY);
        }

        public void moveSquareToTarget(Position newStartPosition) {
            Position movingDistance = this.getSquareStart().getShiftedValue(newStartPosition);
            this.setSquareStart(newStartPosition);
            this.setSquareEnd(this.getSquareEnd().add(movingDistance));
        }

        public void moveSquareToTarget(int newStartX, int newStartY) {
            this.moveSquareToTarget(new Position(newStartX, newStartY));
        }

        public boolean equals(Square otherSquare) {
            return this.getSquareStart().equals(otherSquare.getSquareStart()) && this.getSquareEnd().equals(otherSquare.getSquareEnd());
        }

        public static Square fromNbt(class_2487 nbt) {
            class_2487 startNbt = nbt.method_10562("start");
            class_2487 endNbt = nbt.method_10562("end");
            Position start = Position.fromNbt(startNbt);
            Position end = Position.fromNbt(endNbt);
            return new Square(start, end);
        }

        public void toNbt(class_2487 nbt) {
            class_2487 startNbt = new class_2487();
            class_2487 endNbt = new class_2487();
            this.getSquareStart().toNbt(startNbt);
            this.getSquareEnd().toNbt(endNbt);
            nbt.method_10566("start", (class_2520)startNbt);
            nbt.method_10566("end", (class_2520)endNbt);
        }
    }

    public static class Position {
        private float x;
        private float y;
        public static class_9139<class_9129, Position> CODEC_POSITION = class_9139.method_56435((class_9139)class_9135.field_48552, Position::getX, (class_9139)class_9135.field_48552, Position::getY, Position::new);

        public Position(int x, int y) {
            this((float)x, (float)y);
        }

        public Position(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public Position add(Position input) {
            return new Position(this.getX() + input.getX(), this.getY() + input.getY());
        }

        public Position add(float x, float y) {
            Position position = new Position(x, y);
            return this.add(position);
        }

        public Position getShiftedValue(Position input) {
            return new Position(input.getX() - this.getX(), input.getY() - this.getY());
        }

        public boolean equals(Position otherPosition) {
            return this.getX() == otherPosition.getX() && this.getY() == otherPosition.getY();
        }

        public static Position fromNbt(class_2487 nbt) {
            class_2487 compound = nbt.method_10562("position");
            return new Position(compound.method_10583("x"), compound.method_10583("y"));
        }

        public void toNbt(class_2487 nbt) {
            class_2487 compound = new class_2487();
            compound.method_10548("x", this.getX());
            compound.method_10548("y", this.getY());
            nbt.method_10566("position", (class_2520)compound);
        }

        public String toString() {
            return "x: %s | y: %s".formatted(Float.valueOf(this.getX()), Float.valueOf(this.getY()));
        }
    }
}

