/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.pulchra_occultorum.util.boilerplate;

import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.shirojr.pulchra_occultorum.util.SoundOrigin;

public abstract class AbstractDynamicSoundInstance<T extends SoundOrigin>
extends class_1101 {
    protected final int startTransitionTicks;
    protected final int endTransitionTicks;
    private final float maxAudibleDistance;
    protected final T origin;
    protected TransitionState transitionState;
    protected boolean isFinished = false;
    protected int currentTick = 0;
    protected int transitionTick = 0;
    protected float clampedDistance = 0.0f;

    public AbstractDynamicSoundInstance(T origin, class_3414 soundEvent, class_3419 soundCategory, float maxAudibleDistance, int startTransitionTicks, int endTransitionTicks) {
        super(soundEvent, soundCategory, class_1113.method_43221());
        this.origin = origin;
        this.field_5446 = true;
        this.field_5442 = 0.0f;
        this.transitionState = TransitionState.STARTING;
        this.startTransitionTicks = startTransitionTicks;
        this.endTransitionTicks = endTransitionTicks;
        this.maxAudibleDistance = maxAudibleDistance;
        this.field_5439 = origin.getSoundPos().method_10216();
        this.field_5450 = origin.getSoundPos().method_10214();
        this.field_5449 = origin.getSoundPos().method_10215();
    }

    public void method_16896() {
        if (this.origin.getSoundOriginWorld().method_54719().method_54751()) {
            ++this.currentTick;
        } else {
            return;
        }
        if (this.origin.stoppedExisting()) {
            this.finishSoundInstance();
        }
        switch (this.transitionState.ordinal()) {
            case 0: {
                ++this.transitionTick;
                if (this.transitionTick >= this.startTransitionTicks) {
                    this.transitionState = TransitionState.IDLE;
                    this.transitionTick = 0;
                }
            }
            case 1: {
                if (this.transitionTick < this.endTransitionTicks) {
                    ++this.transitionTick;
                    break;
                }
                this.isFinished = true;
            }
        }
        this.field_5439 = this.origin.getSoundPos().field_1352;
        this.field_5450 = this.origin.getSoundPos().field_1351;
        this.field_5449 = this.origin.getSoundPos().field_1350;
        if (this.isFinished()) {
            this.transitionState = TransitionState.STARTING;
            this.currentTick = 0;
            this.transitionTick = 0;
            this.method_24876();
        }
        AbstractDynamicSoundInstance.defaultSoundHandling(this);
    }

    public boolean method_4785() {
        return true;
    }

    public void finishSoundInstance() {
        this.transitionState = TransitionState.FINISHING;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    protected static void defaultSoundHandling(AbstractDynamicSoundInstance<? extends SoundOrigin> soundInstance) {
        boolean shouldTick = soundInstance.origin.getSoundOriginWorld().method_54719().method_54751();
        if (!shouldTick) {
            soundInstance.clampedDistance = 0.0f;
            soundInstance.field_5442 = 0.0f;
            soundInstance.field_5441 = 1.0f;
        } else {
            soundInstance.transformSoundForDistance();
            soundInstance.transformSoundForMovement();
            soundInstance.transformSoundForTransition(0.0f, 1.0f, true, true);
        }
    }

    protected void transformSoundForMovement() {
        if (this.origin.getSoundOriginVelocity() == null) {
            return;
        }
        double horizontalVelocity = this.origin.getSoundOriginVelocity().method_37267();
        if (horizontalVelocity <= 0.0) {
            this.field_5442 = 0.0f;
        } else {
            this.field_5441 = (float)class_3532.method_16436((double)horizontalVelocity, (double)0.9f, (double)1.2f);
        }
    }

    protected void transformSoundForDistance() {
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (!(class_7462 instanceof class_746)) {
            return;
        }
        class_746 player = class_7462;
        this.clampedDistance = (float)Math.clamp(this.origin.getSoundPos().method_1022(player.method_19538()), 0.0, (double)this.maxAudibleDistance);
        float normalizedIntensity = (this.maxAudibleDistance - this.clampedDistance) / this.maxAudibleDistance;
        this.field_5442 = class_3532.method_16439((float)normalizedIntensity, (float)0.0f, (float)1.3f);
    }

    protected void transformSoundForTransition(float originalVolume, float originalPitch, boolean includeStarting, boolean includeStopping) {
        float normalizedStartTransitionTick = (float)this.transitionTick / (float)this.startTransitionTicks;
        float normalizedEndTransitionTick = (float)this.transitionTick / (float)this.endTransitionTicks;
        switch (this.transitionState.ordinal()) {
            case 0: {
                if (!includeStarting) break;
                this.field_5442 = class_3532.method_16439((float)normalizedStartTransitionTick, (float)0.0f, (float)originalVolume);
                this.field_5441 = class_3532.method_16439((float)normalizedStartTransitionTick, (float)(originalPitch - 0.2f), (float)originalPitch);
                break;
            }
            case 1: {
                if (!includeStopping) break;
                this.field_5442 = class_3532.method_16439((float)normalizedEndTransitionTick, (float)originalVolume, (float)0.0f);
                this.field_5441 = class_3532.method_16439((float)normalizedEndTransitionTick, (float)originalPitch, (float)(originalPitch - 0.2f));
            }
        }
    }

    public static enum TransitionState {
        STARTING,
        FINISHING,
        IDLE;

    }
}

