package com.provismet.provihealth.api;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.resources.EntityOptions;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1299;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public abstract class EntityOptionsDatagenProvider implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> future;
    private final class_7784.class_7489 pathResolver;

    protected EntityOptionsDatagenProvider (FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.future = registriesFuture;
        this.pathResolver = dataOutput.method_45973(class_7784.class_7490.field_39368, ProviHealthClient.MODID + "/entity");
    }

    @Override
    public CompletableFuture<?> method_10319 (class_7403 writer) {
        return this.future.thenCompose(wrapperLookup -> {
            EntityOptionsConsumer consumer = new EntityOptionsConsumer(wrapperLookup);
            this.generate(consumer);

            return CompletableFuture.allOf(consumer.entries.entrySet()
                .stream()
                .map(entry -> {
                    Path path = this.pathResolver.method_44107(entry.getKey());
                    return class_2405.method_10320(writer, entry.getValue(), path);
                })
                .toArray(CompletableFuture[]::new)
            );
        });
    }

    protected abstract void generate (EntityOptionsConsumer entityConsumer);

    @Override
    public String method_10321 () {
        return "ProviHealth Entity Options";
    }

    protected static class EntityOptionsConsumer {
        private final Map<class_2960, JsonElement> entries = new HashMap<>();
        private final class_7225.class_7874 lookup;

        private EntityOptionsConsumer (class_7225.class_7874 lookup) {
            this.lookup = lookup;
        }

        public void add (class_1299<?> type, EntityOptions options) {
            Optional<class_5321<class_1299<?>>> optionalKey = class_7923.field_41177.method_29113(type);
            if (optionalKey.isEmpty()) throw new RuntimeException("Registry key not found for entity type: " + type.toString());

            DataResult<JsonElement> json = EntityOptions.CODEC.encodeStart(lookup.method_57093(JsonOps.INSTANCE), options);
            this.entries.put(optionalKey.get().method_29177(), json.mapError(message -> "Invalid entry for entity type %s: %s".formatted(optionalKey.get().method_29177().toString(), message)).getOrThrow());
        }
    }
}
