package com.provismet.provihealth.api;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.resources.TagOptions;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1299;
import net.minecraft.class_2405;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class TagOptionsDatagenProvider implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> future;
    private final class_7784.class_7489 pathResolver;

    protected TagOptionsDatagenProvider (FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.future = registriesFuture;
        this.pathResolver = dataOutput.method_45973(class_7784.class_7490.field_39368, ProviHealthClient.MODID + "/tag");
    }

    @Override
    public CompletableFuture<?> method_10319 (class_7403 writer) {
        return this.future.thenCompose(wrapperLookup -> {
            TagConsumer consumer = new TagConsumer(wrapperLookup);
            this.generate(wrapperLookup, consumer);

            return CompletableFuture.allOf(consumer.entries.entrySet()
                .stream()
                .map(entry -> {
                    Path path = this.pathResolver.method_44107(entry.getKey().comp_327());
                    return class_2405.method_10320(writer, entry.getValue(), path);
                })
                .toArray(CompletableFuture[]::new)
            );
        });
    }

    protected abstract void generate (class_7225.class_7874 lookup, TagConsumer tagConsumer);

    @Override
    public String method_10321 () {
        return "ProviHealth Tag Options";
    }

    protected static class TagConsumer {
        private final Map<class_6862<class_1299<?>>, JsonElement> entries = new HashMap<>();
        private final class_7225.class_7874 lookup;

        private TagConsumer (class_7225.class_7874 lookup) {
            this.lookup = lookup;
        }

        public void add (class_6862<class_1299<?>> tag, TagOptions options) {
            DataResult<JsonElement> json = TagOptions.CODEC.encodeStart(lookup.method_57093(JsonOps.INSTANCE), options);
            this.entries.put(tag, json.mapError(message -> "Invalid entry %s: %s".formatted(tag.comp_327(), message)).getOrThrow());
        }
    }
}
