package com.provismet.provihealth.compat;

import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.config.Options.DamageParticleType;
import com.provismet.provihealth.config.Options.HUDPortraitCompatMode;
import com.provismet.provihealth.config.Options.HUDPosition;
import com.provismet.provihealth.config.Options.HUDType;
import com.provismet.provihealth.config.Options.SeeThroughText;
import com.provismet.provihealth.config.Options.VisibilityType;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import java.util.Arrays;
import java.util.List;

public class ProviHealthConfigScreen {
    public static class_437 build (class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        builder.setTitle(class_2561.method_43471("title.provihealth.config"));
        builder.setDefaultBackgroundTexture(class_2960.method_60654("textures/block/deepslate_tiles.png"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        ConfigCategory hud = builder.getOrCreateCategory(class_2561.method_43471("category.provihealth.hud"));
        ConfigCategory health = builder.getOrCreateCategory(class_2561.method_43471("category.provihealth.health"));
        ConfigCategory particles = builder.getOrCreateCategory(class_2561.method_43471("category.provihealth.particles"));
        ConfigCategory compatibility = builder.getOrCreateCategory(class_2561.method_43471("category.provihealth.compat"));

        hud.addEntry(entryBuilder.startIntField(class_2561.method_43471("entry.provihealth.hudDuration"), Options.maxHealthBarTicks)
            .setDefaultValue(40)
            .setMin(0)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.hudDuration"))
            .setSaveConsumer(newValue -> Options.maxHealthBarTicks = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.showIcon"), Options.showHudIcon)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.showHudIcon = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.hudPortraits"), Options.useCustomHudPortraits)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.hudPortraits"))
            .setSaveConsumer(newValue -> Options.useCustomHudPortraits = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.hudGlide"), Options.hudGlide)
            .setDefaultValue(0.5f)
            .setMin(0.01f)
            .setMax(1f)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.glide"))
            .setSaveConsumer(newValue -> Options.hudGlide = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.hudOffsetX"), HUDPosition.class, Options.hudPosition)
            .setDefaultValue(HUDPosition.LEFT)
            .setSaveConsumer(newValue -> Options.hudPosition = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startIntSlider(class_2561.method_43471("entry.provihealth.hudOffsetY"), Options.hudOffsetPercent, 0, 100)
            .setDefaultValue(0)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.hudOffsetY"))
            .setSaveConsumer(newValue -> Options.hudOffsetPercent = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.hudTitles"), Options.hudTitles)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.hudTitles"))
            .setSaveConsumer(newValue -> Options.hudTitles = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.hudStatuses"), Options.hudStatuses)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.hudStatuses = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.gradient"), Options.hudGradient)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.gradient"))
            .setSaveConsumer(newValue -> Options.hudGradient = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.barStartColour"), Options.hudStartColour)
            .setDefaultValue(0x00C100)
            .setSaveConsumer(newValue -> {
                Options.hudStartColour = newValue;
                Options.unpackedStartHud = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        hud.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.barEndColour"), Options.hudEndColour)
            .setDefaultValue(0xFF0000)
            .setSaveConsumer(newValue -> {
                Options.hudEndColour = newValue;
                Options.unpackedEndHud = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        hud.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.boss"), HUDType.class, Options.bossHUD)
            .setDefaultValue(HUDType.FULL)
            .setSaveConsumer(newValue -> Options.bossHUD = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.hostile"), HUDType.class, Options.hostileHUD)
            .setDefaultValue(HUDType.FULL)
            .setSaveConsumer(newValue -> Options.hostileHUD = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.player"), HUDType.class, Options.playerHUD)
            .setDefaultValue(HUDType.FULL)
            .setSaveConsumer(newValue -> Options.playerHUD = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.other"), HUDType.class, Options.otherHUD)
            .setDefaultValue(HUDType.FULL)
            .setSaveConsumer(newValue -> Options.otherHUD = newValue)
            .build()
        );

        hud.addEntry(entryBuilder.startStrList(class_2561.method_43471("entry.provihealth.blacklist"), Options.blacklistHUD)
            .setDefaultValue(List.of("minecraft:armor_stand"))
            .setSaveConsumer(newValue -> Options.blacklistHUD = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.overrideLabels"), Options.overrideLabels)
            .setDefaultValue(false)
            .setSaveConsumer(newValue -> Options.overrideLabels = newValue)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.overrideLabels"))
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.worldText"), Options.showTextInWorld)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.showTextInWorld = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.worldShadows"), Options.worldShadows)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.worldShadows = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.maxDistance"), Options.maxRenderDistance)
            .setMin(0f)
            .setDefaultValue(24f)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.maxDistance"))
            .setSaveConsumer(newValue -> Options.maxRenderDistance = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.barScale"), Options.worldHealthBarScale)
            .setMin(0.01f)
            .setMax(3f)
            .setDefaultValue(1.5f)
            .setSaveConsumer(newValue -> Options.worldHealthBarScale = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.worldOffsetY"), Options.worldOffsetY)
            .setDefaultValue(0f)
            .setSaveConsumer(newValue -> Options.worldOffsetY = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.worldTitles"), Options.worldTitles)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.worldTitles"))
            .setSaveConsumer(newValue -> Options.worldTitles = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.tintBackground"), Options.tintBackground)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.tintBackground"))
            .setSaveConsumer(newValue -> Options.tintBackground = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.teamColours"), Options.useTeamColours)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.teamColours"))
            .setSaveConsumer(newValue -> Options.useTeamColours = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.gradient"), Options.worldGradient)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.gradient"))
            .setSaveConsumer(newValue -> Options.worldGradient = newValue)
            .build()
        );

        health.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.barStartColour"), Options.worldStartColour)
            .setDefaultValue(0x00C100)
            .setSaveConsumer(newValue -> {
                Options.worldStartColour = newValue;
                Options.unpackedStartWorld = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        health.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.barEndColour"), Options.worldEndColour)
            .setDefaultValue(0xFF0000)
            .setSaveConsumer(newValue -> {
                Options.worldEndColour = newValue;
                Options.unpackedEndWorld = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        health.addEntry(entryBuilder.startSubCategory(class_2561.method_43471("subcategory.provihealth.boss"), Arrays.asList(
                entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.healthBar"), VisibilityType.class, Options.bosses)
                    .setDefaultValue(VisibilityType.ALWAYS_HIDE)
                    .setSaveConsumer(newValue -> Options.bosses = newValue)
                    .build(),
                entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.targetOverride"), Options.bossesVisibilityOverride)
                    .setDefaultValue(false)
                    .setTooltip(class_2561.method_43471("tooltip.provihealth.targetOverride"))
                    .setSaveConsumer(newValue -> Options.bossesVisibilityOverride = newValue)
                    .build()
            ))
            .build()
        );

        health.addEntry(entryBuilder.startSubCategory(class_2561.method_43471("subcategory.provihealth.hostile"), Arrays.asList(
                entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.healthBar"), VisibilityType.class, Options.hostile)
                    .setDefaultValue(VisibilityType.ALWAYS_SHOW)
                    .setSaveConsumer(newValue -> Options.hostile = newValue)
                    .build(),
                entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.targetOverride"), Options.hostileVisibilityOverride)
                    .setDefaultValue(true)
                    .setTooltip(class_2561.method_43471("tooltip.provihealth.targetOverride"))
                    .setSaveConsumer(newValue -> Options.hostileVisibilityOverride = newValue)
                    .build()
            ))
            .build()
        );

        health.addEntry(entryBuilder.startSubCategory(class_2561.method_43471("subcategory.provihealth.player"), Arrays.asList(
                entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.healthBar"), VisibilityType.class, Options.players)
                    .setDefaultValue(VisibilityType.HIDE_IF_FULL)
                    .setSaveConsumer(newValue -> Options.players = newValue)
                    .build(),
                entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.targetOverride"), Options.playersVisibilityOverride)
                    .setDefaultValue(true)
                    .setTooltip(class_2561.method_43471("tooltip.provihealth.targetOverride"))
                    .setSaveConsumer(newValue -> Options.playersVisibilityOverride = newValue)
                    .build()
            ))
            .build()
        );

        health.addEntry(entryBuilder.startSubCategory(class_2561.method_43471("subcategory.provihealth.other"), Arrays.asList(
                entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.healthBar"), VisibilityType.class, Options.others)
                    .setDefaultValue(VisibilityType.HIDE_IF_FULL)
                    .setSaveConsumer(newValue -> Options.others = newValue)
                    .build(),
                entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.targetOverride"), Options.othersVisibilityOverride)
                    .setDefaultValue(true)
                    .setTooltip(class_2561.method_43471("tooltip.provihealth.targetOverride"))
                    .setSaveConsumer(newValue -> Options.othersVisibilityOverride = newValue)
                    .build()
            ))
            .build()
        );

        health.addEntry(entryBuilder.startStrList(class_2561.method_43471("entry.provihealth.blacklist"), Options.blacklist)
            .setDefaultValue(List.of("minecraft:armor_stand"))
            .setSaveConsumer(newValue -> Options.blacklist = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.damageParticles"), Options.spawnDamageParticles)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.spawnDamageParticles = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.healingParticles"), Options.spawnHealingParticles)
            .setDefaultValue(false)
            .setSaveConsumer(newValue -> Options.spawnHealingParticles = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.particleType"), DamageParticleType.class, Options.particleType)
            .setDefaultValue(DamageParticleType.RISING)
            .setSaveConsumer(newValue -> Options.particleType = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.damageColour"), Options.damageColour)
            .setDefaultValue(0xFF0000)
            .setSaveConsumer(newValue -> {
                Options.damageColour = newValue;
                Options.unpackedDamage = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        particles.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.damageAlpha"), Options.damageAlpha)
            .setDefaultValue(1f)
            .setMin(0f)
            .setMax(1f)
            .setSaveConsumer(newValue -> Options.damageAlpha = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startColorField(class_2561.method_43471("entry.provihealth.healingColour"), Options.healingColour)
            .setDefaultValue(0x00FF00)
            .setSaveConsumer(newValue -> {
                Options.healingColour = newValue;
                Options.unpackedHealing = class_243.method_24457(newValue).method_46409();
            })
            .build()
        );

        particles.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.healingAlpha"), Options.healingAlpha)
            .setDefaultValue(1f)
            .setMin(0f)
            .setMax(1f)
            .setSaveConsumer(newValue -> Options.healingAlpha = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startAlphaColorField(class_2561.method_43471("entry.provihealth.damageParticleTextColour"), Options.damageParticleTextColour)
            .setDefaultValue(0xFFFFFFFF)
            .setSaveConsumer(newValue -> Options.damageParticleTextColour = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startAlphaColorField(class_2561.method_43471("entry.provihealth.healingParticleTextColour"), Options.healingParticleTextColour)
            .setDefaultValue(0xFFFFFFFF)
            .setSaveConsumer(newValue -> Options.healingParticleTextColour = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.provihealth.particleTextShadow"), Options.particleTextShadow)
            .setDefaultValue(true)
            .setSaveConsumer(newValue -> Options.particleTextShadow = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.particleScale"), Options.particleScale)
            .setDefaultValue(0.25f)
            .setMin(0.01f)
            .setSaveConsumer(newValue -> Options.particleScale = newValue)
            .build()
        );

        particles.addEntry(entryBuilder.startFloatField(class_2561.method_43471("entry.provihealth.maxParticleDistance"), Options.maxParticleDistance)
            .setDefaultValue(16f)
            .setMin(0f)
            .setSaveConsumer(newValue -> Options.maxParticleDistance = newValue)
            .build()
        );

        compatibility.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.compatText"), SeeThroughText.class, Options.seeThroughTextType)
            .setDefaultValue(SeeThroughText.STANDARD)
            .setTooltip(class_2561.method_43471("tooltip.provihealth.compatText"))
            .setSaveConsumer(newValue -> Options.seeThroughTextType = newValue)
            .build()
        );

        /*
        compatibility.addEntry(entryBuilder.startBooleanToggle(Text.translatable("entry.provihealth.compatWorld"), Options.compatInWorld)
            .setDefaultValue(false)
            .setTooltip(Text.translatable("tooltip.provihealth.compatWorld"))
            .setSaveConsumer(newValue -> Options.compatInWorld = newValue)
            .build()
        );
         */

        compatibility.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("entry.provihealth.compatHud"), HUDPortraitCompatMode.class, Options.HUDCompat)
            .setDefaultValue(HUDPortraitCompatMode.STANDARD)
            .setSaveConsumer(newValue -> Options.HUDCompat = newValue)
            .build()
        );

        builder.setSavingRunnable(Options::save);
        return builder.build();
    }
}
