package com.provismet.provihealth.config.resources;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.hud.ElementRegistry;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;

public class EntityOptions {
    public static final EntityOptions DEFAULT = new EntityOptions(null, null, null, null);

    public static final Codec<EntityOptions> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            class_2960.field_25139.optionalFieldOf("border").forGetter(options -> Optional.ofNullable(options.border)),
            class_2960.field_25139.optionalFieldOf("healthbar").forGetter(options -> Optional.ofNullable(options.healthBar)),
            class_1799.field_24671.optionalFieldOf("icon").forGetter(options -> Optional.ofNullable(options.icon)),
            class_5699.field_41759.optionalFieldOf("hudType").forGetter(options -> Optional.ofNullable(options.hudType).map(Enum::name))
        ).apply(instance, (border, health, icon, hud) -> new EntityOptions(border.orElse(null), health.orElse(null), icon.orElse(null), hud.orElse(null)))
    );

    private final class_2960 border;
    private final class_2960 healthBar;
    private final class_1799 icon;
    private final Options.HUDType hudType;

    public EntityOptions (class_2960 border, class_2960 healthBar, class_1799 icon, String hudType) {
        this.border = border;
        this.healthBar = healthBar;
        this.icon = icon;
        if (hudType == null) this.hudType = null;
        else this.hudType = Options.HUDType.valueOf(hudType);
    }

    @NotNull
    public class_2960 getBorder (class_1309 entity) {
        if (this.border == null) return Objects.requireNonNullElse(ElementRegistry.getOrCacheBorder(entity), ElementRegistry.DEFAULT_BORDER);
        if (!Options.useCustomHudPortraits) return ElementRegistry.DEFAULT_BORDER;
        return this.border;
    }

    @NotNull
    public class_2960 getHealthBar (class_1309 entity) {
        if (this.healthBar == null) return Objects.requireNonNullElse(ElementRegistry.getOrCacheHealthBar(entity), ElementRegistry.DEFAULT_BARS);
        return this.healthBar;
    }

    @Nullable
    public class_1799 getIcon (class_1309 entity) {
        if (this.icon == null) return ElementRegistry.getOrCacheIcon(entity);
        return this.icon;
    }

    @NotNull
    public Options.HUDType getHudType (class_1309 entity) {
        if (Options.isBlacklisted(entity, Options.BarType.HUD)) return Options.HUDType.NONE;
        if (this.hudType == null) {
            Options.HUDType fromCache = ElementRegistry.getOrCacheHudType(entity);
            if (fromCache != null) return fromCache;

            if (entity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) return Options.bossHUD;
            else if (entity instanceof class_1588) return Options.hostileHUD;
            else if (entity instanceof class_1657) return Options.playerHUD;
            else return Options.otherHUD;
        }
        return this.hudType;
    }
}
