package com.provismet.provihealth.config.resources;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.provihealth.config.Options;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class TagOptions {
    public static final Codec<TagOptions> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            Codec.INT.fieldOf("priority").forGetter(TagOptions::getPriority),
            class_2960.field_25139.optionalFieldOf("border").forGetter(options -> Optional.ofNullable(options.border)),
            class_2960.field_25139.optionalFieldOf("healthbar").forGetter(options -> Optional.ofNullable(options.healthBar)),
            class_1799.field_24671.optionalFieldOf("icon").forGetter(options -> Optional.ofNullable(options.icon)),
            class_5699.field_41759.optionalFieldOf("hudType").forGetter(options -> Optional.ofNullable(options.hudType).map(Enum::name))
        ).apply(instance, (priority, border, health, icon, hud) -> new TagOptions(
            priority,
            border.orElse(null),
            health.orElse(null),
            icon.orElse(null),
            hud.orElse(null)
        ))
    );

    private final int priority;
    private final class_2960 border;
    private final class_2960 healthBar;
    private final class_1799 icon;
    private final Options.HUDType hudType;

    public TagOptions (int priority, class_2960 border, class_2960 healthBar, class_1799 icon, String hudType) {
        this.priority = priority;
        this.border = border;
        this.healthBar = healthBar;
        this.icon = icon;
        if (hudType == null) this.hudType = null;
        else this.hudType = Options.HUDType.valueOf(hudType);
    }

    public int getPriority () {
        return this.priority;
    }

    @Nullable
    public class_2960 getBorder () {
        return this.border;
    }

    @Nullable
    public class_2960 getHealthBar () {
        return this.healthBar;
    }

    @Nullable
    public class_1799 getIcon () {
        return this.icon;
    }

    @Nullable
    public Options.HUDType getHudType () {
        return this.hudType;
    }
}
