package com.provismet.provihealth.hud;

import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.config.Options.HUDPortraitCompatMode;
import com.provismet.provihealth.config.Options.HUDPosition;
import com.provismet.provihealth.config.Options.HUDType;
import com.provismet.provihealth.config.resources.EntityOptions;
import com.provismet.provihealth.interfaces.IMixinEntityRenderState;
import com.provismet.provihealth.interfaces.IMixinLivingEntity;
import com.provismet.provihealth.util.ColourHelper;
import com.provismet.provihealth.util.HealthCalculator;
import com.provismet.provihealth.util.HealthContainer;
import com.provismet.provihealth.util.Visibility;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_8012;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.List;

public class TargetHealthBar implements HudElement {
    public static final class_2960 HEALTHBAR_LAYER = ProviHealthClient.identifier("healthbar_layer");

    private static final class_2960 COMPAT_BARS = ProviHealthClient.identifier("textures/gui/healthbars/bars_coloured.png");
    private static final class_2960 HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/heart.png");
    private static final class_2960 MOUNT_HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/mount_heart.png");
    private static final class_2960 ARMOUR = ProviHealthClient.identifier("textures/gui/healthbars/icons/armour.png");

    private static int OFFSET_X = 0;
    private static int OFFSET_Y = 0;
    private static final int BAR_WIDTH = 128;
    private static final int BAR_HEIGHT = 10;
    private static final int MOUNT_BAR_HEIGHT = 6;
    private static final int MOUNT_BAR_WIDTH = 121;
    private static final int FRAME_LENGTH = 48;
    private static final int LEFT_TEXT_X = FRAME_LENGTH + 2;
    private static int BAR_X = FRAME_LENGTH - 5;
    private static int BAR_Y = OFFSET_Y + FRAME_LENGTH / 2 - (BAR_HEIGHT + MOUNT_BAR_HEIGHT) / 2;

    private static int TEXT_BASE_Y = BAR_Y + BAR_HEIGHT + 1;

    private static int EFFECT_X = FRAME_LENGTH + 2;
    private static int EFFECT_BASE_Y = TEXT_BASE_Y + 11;
    private static int EFFECT_X_OFFSET = 17;

    private static final float BAR_V2 = ((float)BAR_HEIGHT / (float)(BAR_HEIGHT + MOUNT_BAR_HEIGHT)) / 2f; // Accounting for index.
    private static final float MOUNT_BAR_U2 = (float)MOUNT_BAR_WIDTH / (float)BAR_WIDTH;
    private static final float MOUNT_BAR_V1 = ((float)BAR_HEIGHT / (float)(BAR_HEIGHT + MOUNT_BAR_HEIGHT)) / 2f;
    private static final float MOUNT_BAR_V2 = 0.5f; // Accounting for index.

    private static final int BAR_WIDTH_DIFF = BAR_WIDTH - MOUNT_BAR_WIDTH;

    private class_1309 target = null;
    private float healthBarDuration = 0f;

    private int currentHealthWidth;
    private int currentVehicleHealthWidth;

    @Override
    public void render (class_332 drawContext, class_9779 tickCounter) {
        float tickDelta = tickCounter.method_60637(true);
        if (this.healthBarDuration > 0f) this.healthBarDuration -= tickDelta;
        else this.reset();

        if (!class_310.method_1498()
            || class_310.method_1551().method_53526().method_53536()
            || (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7325())) return;

        boolean isNewTarget = false;

        if (class_310.method_1551().field_1692 instanceof class_1309 living) {
            if (!Visibility.isVisible(living)) return;
            if (!living.equals(this.target)) isNewTarget = true;
            this.target = living;
            this.healthBarDuration = Options.maxHealthBarTicks;
        }

        if (this.healthBarDuration <= 0f) return;
        if (this.target == null) {
            this.reset();
            return;
        }

        this.adjustForScreenSize();
        EntityOptions entityOptions = ElementRegistry.getEntityOptions(this.target);
        HUDType hudType = entityOptions.getHudType(this.target);

        float healthPercent = class_3532.method_15363(this.target.method_6032() / this.target.method_6063(), 0f, 1f);

        HealthContainer mountHealth = HealthCalculator.getRecursiveMountHealth(target, Options.BarType.HUD);
        float vehicleHealthPercent = mountHealth != null ? mountHealth.getPercentage() : 0f;

        int healthWidth = Math.round(BAR_WIDTH * healthPercent);
        int vehicleHealthWidth = Math.round(MOUNT_BAR_WIDTH * vehicleHealthPercent);

        if (isNewTarget) {
            this.currentHealthWidth = healthWidth;
            this.currentVehicleHealthWidth = vehicleHealthWidth;
        }

        final int nameWidth = class_310.method_1551().field_1772.method_27525(this.getName(this.target));
        if (hudType.showBars) {
            // Render bars
            class_2960 healthbarTexture = entityOptions.getHealthBar(this.target);
            this.renderBar(drawContext, healthbarTexture, BAR_WIDTH, 1); // Empty space
            this.renderBar(drawContext, healthbarTexture, glideHealth(healthWidth, tickDelta * Options.hudGlide), 0); // Health
            if (mountHealth != null) {
                this.renderMountBar(drawContext, healthbarTexture, MOUNT_BAR_WIDTH, 1); // Empty space
                this.renderMountBar(drawContext, healthbarTexture, glideVehicleHealth(vehicleHealthWidth, tickDelta * Options.hudGlide), 0); // Health
            }

            // Render entity group icon
            int infoLeftX = LEFT_TEXT_X;
            class_1799 icon = entityOptions.getIcon(this.target);
            if (Options.hudPosition == HUDPosition.LEFT) {
                int expectedNameX = LEFT_TEXT_X + nameWidth + 2; // Starting point + width + 2 pixels of free space.
                if (icon != null && Options.showHudIcon) drawContext.method_51427(icon, Math.max(BAR_X + BAR_WIDTH - 16, expectedNameX), BAR_Y - 16);
            }
            else {
                int expectedNameX = OFFSET_X - 18 - nameWidth; // Leftmost pixel of name, then left by 2 pixels, then left by 16 to make space for the icon.
                if (icon != null && Options.showHudIcon) drawContext.method_51427(icon, Math.min(BAR_X, expectedNameX), BAR_Y - 16);
                infoLeftX = BAR_X + 3;
            }

            // Render health value and heart icons
            int offsetFromMountBar = (mountHealth != null ? MOUNT_BAR_HEIGHT : 0);
            int healthX = this.drawTextAndGetWidth(drawContext, String.format("%d/%d", Math.round(this.target.method_6032()), Math.round(this.target.method_6063())), infoLeftX, TEXT_BASE_Y + 1 + offsetFromMountBar, 0xFFFFFF, true); // Health Value
            drawContext.method_25302(class_10799.field_56883, HEART, healthX, TEXT_BASE_Y + offsetFromMountBar, 0f, 0f, 9, 9, 9, 9, 9, 9);

            // Render armour icon if necessary
            int armourX = class_310.method_1551().field_1772.method_1727(String.format("%d/%d", Math.round(this.target.method_6063()), Math.round(this.target.method_6063()))) + infoLeftX + 18;
            if (this.target.method_6096() > 0) {
                armourX = this.drawTextAndGetWidth(drawContext, String.format("%d", this.target.method_6096()), armourX, TEXT_BASE_Y + 1 + offsetFromMountBar, 0xFFFFFF, true);
                drawContext.method_25302(class_10799.field_56883, ARMOUR, armourX, TEXT_BASE_Y + offsetFromMountBar, 0f, 0f, 9, 9, 9, 9, 9, 9);
            }

            // Render mount health icon/text if necessary
            if (mountHealth != null) {
                String mountHealthString = String.format("%d/%d", Math.round(mountHealth.getCurrent()), Math.round(mountHealth.getMax()));
                int mountHealthWidth = class_310.method_1551().field_1772.method_1727(mountHealthString) + 9;
                int expectedLeftPixel = BAR_X + BAR_WIDTH - mountHealthWidth - 3;

                if (expectedLeftPixel < armourX) expectedLeftPixel = armourX + 10;

                int mountHealthX = this.drawTextAndGetWidth(drawContext, mountHealthString, expectedLeftPixel, TEXT_BASE_Y + 1 + MOUNT_BAR_HEIGHT, 0xFFFFFF, true);
                drawContext.method_25302(class_10799.field_56883, MOUNT_HEART, mountHealthX, TEXT_BASE_Y + MOUNT_BAR_HEIGHT, 0f, 0f, 9, 9, 9, 9, 9, 9);
            }

            if (Options.hudStatuses) {
                List<class_6880<class_1291>> effects = ((IMixinLivingEntity)this.target).provi_Health$getClientSideStatusEffects();

                if (!effects.isEmpty()) {
                    int effectXOffset = 0;
                    for (class_6880<class_1291> effect : effects) {
                        class_2960 effectTexture = class_329.method_71644(effect);
                        drawContext.method_52706(class_10799.field_56883, effectTexture, EFFECT_X + effectXOffset, EFFECT_BASE_Y + offsetFromMountBar, 16, 16);
                        effectXOffset += EFFECT_X_OFFSET;
                    }
                }
            }
        }

        if (Options.hudTitles && hudType.showTitles) {
            List<class_2561> titles = ElementRegistry.getTitle(this.target, false, true).reversed();

            int titleX = 5;
            int titleY = OFFSET_Y + FRAME_LENGTH + 5;

            if (Options.hudPosition == HUDPosition.LEFT) {
                for (class_2561 title : titles) {
                    drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, class_8012.field_42973, true);
                    titleY += 10;
                }
            }
            else {
                for (class_2561 title : titles) {
                    titleX = class_310.method_1551().method_22683().method_4486() - 10 - class_310.method_1551().field_1772.method_27525(title);
                    drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, class_8012.field_42973, true);
                    titleY += 10;
                }
            }
        }

        if (hudType.showPortrait) {
            // Render Portrait Background and Text (foreground comes later)
            if (Options.hudPosition == HUDPosition.LEFT) {
                this.drawTexturedWhiteQuad(entityOptions.getBorder(this.target), drawContext, 0, OFFSET_Y, 48f, 0f, FRAME_LENGTH, FRAME_LENGTH, FRAME_LENGTH * 2, FRAME_LENGTH); // Background
                drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), LEFT_TEXT_X, BAR_Y - BAR_HEIGHT, class_8012.field_42973, true); // Name
            }
            else {
                this.drawHorizontallyMirroredTexturedQuad(entityOptions.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + FRAME_LENGTH, OFFSET_Y, OFFSET_Y + FRAME_LENGTH, 0.5f, 1f, 0f, 1f, class_8012.field_42973); // Background
                drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), OFFSET_X - 1 - nameWidth, BAR_Y - BAR_HEIGHT, class_8012.field_42973, true); // Name
            }

            // Render Paper Doll
            if (Options.HUDCompat == HUDPortraitCompatMode.STANDARD) {
                float prevTargetHeadYaw = this.target.field_6241;
                float prevPrevTargetHeadYaw = this.target.field_6259;
                float prevTargetBodyYaw = this.target.field_6283;
                float prevPrevTargetBodyYaw = this.target.field_6220;

                this.target.field_6283 = Options.hudPosition.portraitYAW;
                this.target.field_6220 = Options.hudPosition.portraitYAW;
                this.target.field_6241 = Options.hudPosition.portraitYAW;
                this.target.field_6259 = Options.hudPosition.portraitYAW;

                this.drawEntity(drawContext, (new Quaternionf()).rotateZ(3.1415927f));

                this.target.field_6241 = prevTargetHeadYaw;
                this.target.field_6259 = prevPrevTargetHeadYaw;
                this.target.field_6283 = prevTargetBodyYaw;
                this.target.field_6220 = prevPrevTargetBodyYaw;
            }
            else if (Options.HUDCompat == HUDPortraitCompatMode.COMPAT) {
                float yawOffset = -(Options.hudPosition.portraitYAW - this.target.method_73188()) / class_3532.field_29848;
                this.drawEntity(drawContext, (new Quaternionf()).rotateZ(3.1415927f).rotateY(yawOffset));
            }

            // Draw portrait background.
            if (Options.hudPosition == HUDPosition.LEFT) {
                this.drawTexturedWhiteQuad(entityOptions.getBorder(this.target), drawContext, 0, OFFSET_Y, 0f, 0f, FRAME_LENGTH, FRAME_LENGTH, FRAME_LENGTH * 2, FRAME_LENGTH);
            }
            else {
                this.drawHorizontallyMirroredTexturedQuad(entityOptions.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + FRAME_LENGTH, OFFSET_Y, OFFSET_Y + FRAME_LENGTH, 0f, 0.5f, 0f, 1f, class_8012.field_42973); // Foreground
            }
        }
    }

    private class_2561 getName (class_1309 entity) {
        if (entity instanceof class_1657 && entity.method_5756(class_310.method_1551().field_1724)) return class_2561.method_43471("entity.provihealth.unknownPlayer");
        else return entity.method_5476();
    }

    private int glideHealth (int trueValue, float glideFactor) {
        this.currentHealthWidth += (int)((float)(trueValue - this.currentHealthWidth) * class_3532.method_15363(glideFactor, 0.001f, 1f));
        return this.currentHealthWidth;
    }

    private int glideVehicleHealth (int trueValue, float glideFactor) {
        this.currentVehicleHealthWidth += (int)((float)(trueValue - this.currentVehicleHealthWidth) * class_3532.method_15363(glideFactor, 0.001f, 1f));
        return this.currentVehicleHealthWidth;
    }

    private void renderBar (class_332 drawContext, class_2960 texture, int width, int barIndex) {
        int barColour = ColourHelper.lerpBarColour((float)width / (float)BAR_WIDTH, barIndex == 1 ? class_8012.field_42973 : Options.hudStartColour, Options.hudEndColour, barIndex == 0 && Options.hudGradient);
        if (Options.hudPosition == HUDPosition.LEFT) drawContext.method_25295(class_10799.field_56883, texture, BAR_X, BAR_X + width, BAR_Y, BAR_Y + BAR_HEIGHT, 0f, (float)width / (float)BAR_WIDTH, barIndex / 2f, BAR_V2 + barIndex / 2f, barColour);
        else this.drawHorizontallyMirroredTexturedQuad(texture, drawContext, BAR_X + (BAR_WIDTH - width), BAR_X + BAR_WIDTH, BAR_Y, BAR_Y + BAR_HEIGHT, 0f, (float)width / (float)BAR_WIDTH, barIndex / 2f, BAR_V2 + barIndex / 2f, barColour);
    }

    private void renderMountBar (class_332 drawContext, class_2960 texture, int width, int barIndex) {
        int barColour = ColourHelper.lerpBarColour((float)width / (float)MOUNT_BAR_WIDTH, barIndex == 1 ? class_8012.field_42973 : Options.hudStartColour, Options.hudEndColour, barIndex == 0 && Options.hudGradient);
        if (Options.hudPosition == HUDPosition.LEFT) drawContext.method_25295(class_10799.field_56883, texture, BAR_X, BAR_X + width, BAR_Y + BAR_HEIGHT, BAR_Y + BAR_HEIGHT + MOUNT_BAR_HEIGHT, 0f, ((float)width / (float)MOUNT_BAR_WIDTH) * MOUNT_BAR_U2, MOUNT_BAR_V1 + barIndex / 2f, MOUNT_BAR_V2 + barIndex / 2f, barColour);
        else this.drawHorizontallyMirroredTexturedQuad(texture, drawContext, BAR_X + (MOUNT_BAR_WIDTH - width) + BAR_WIDTH_DIFF, BAR_X + BAR_WIDTH_DIFF + MOUNT_BAR_WIDTH, BAR_Y + BAR_HEIGHT, BAR_Y + BAR_HEIGHT + MOUNT_BAR_HEIGHT, 0f, ((float)width / (float)MOUNT_BAR_WIDTH) * MOUNT_BAR_U2, MOUNT_BAR_V1 + barIndex / 2f, MOUNT_BAR_V2 + barIndex / 2f, barColour);
    }

    private void reset () {
        this.healthBarDuration = 0f;
        this.target = null;
        this.currentHealthWidth = 0;
        this.currentVehicleHealthWidth = 0;
    }

    private void adjustForScreenSize () {
        OFFSET_Y = Math.min((int)(class_310.method_1551().method_22683().method_4502() * (Options.hudOffsetPercent / 100f)), class_310.method_1551().method_22683().method_4502() - FRAME_LENGTH);
        BAR_Y = OFFSET_Y + FRAME_LENGTH / 2 - (BAR_HEIGHT + MOUNT_BAR_HEIGHT) / 2;
        TEXT_BASE_Y = BAR_Y + BAR_HEIGHT + 1;
        EFFECT_BASE_Y = TEXT_BASE_Y + 11;

        if (Options.hudPosition == HUDPosition.LEFT) {
            OFFSET_X = 0;
            BAR_X = FRAME_LENGTH - 5;
            EFFECT_X = FRAME_LENGTH + 2;
            EFFECT_X_OFFSET = 17;
        }
        else {
            int width = class_310.method_1551().method_22683().method_4486();
            OFFSET_X = width - FRAME_LENGTH;
            BAR_X = OFFSET_X + 5 - BAR_WIDTH;
            EFFECT_X = OFFSET_X - 18;
            EFFECT_X_OFFSET = -17;
        }
    }

    private void drawHorizontallyMirroredTexturedQuad (class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, int colour) {
        this.drawTexturedQuad(texture, context, x1, x2, y1, y2, u2, u1, v1, v2, colour);
    }

    private void drawTexturedWhiteQuad (class_2960 texture, class_332 context, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        this.drawTexturedQuad(texture, context, x, x + width, y, y + height, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight, class_8012.field_42973);
    }

    /**
     * Recreation of DrawContext#drawTexturedQuad that allows for changing the layering order (z-axis).
     *
     * @param texture The location of the texture to draw.
     * @param context The DrawContext to get rendering data from.
     * @param x1 The screen-coordinate of the leftmost pixel.
     * @param x2 The screen-coordinate of the rightmost pixel.
     * @param y1 The screen-coordinate of the topmost pixel.
     * @param y2 The screen-coordinate of the bottommost pixel.
     * @param u1 As a percentage of the texture-width, the leftmost pixel to read and render.
     * @param u2 As a percentage of the texture-width, the rightmost pixel to read and render.
     * @param v1 As a percentage of the texture-height, the topmost pixel to read and render.
     * @param v2 As a percentage of the texture-height, the bottommost pixel to read and render.
     * @param colour Colour expressed as a vector. See {@link class_243#method_24457(int)}
     */
    private void drawTexturedQuad (class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, int colour) {
        context.field_59826.method_70919(
            new class_11241(
                class_10799.field_56883,
                class_11231.method_70900(class_310.method_1551().method_1531().method_4619(texture).method_71659()),
                context.method_51448(),
                x1, y1,
                x2, y2,
                u1, u2,
                v1, v2,
                colour,
                context.field_44659.method_70863()
            )
        );
    }

    private int drawTextAndGetWidth (class_332 context, String text, int x, int y, int colour, boolean shadow) {
        context.method_51433(class_310.method_1551().field_1772, text, x, y, class_9848.method_61334(colour), shadow);
        return x + class_310.method_1551().field_1772.method_1727(text);
    }

    private void drawEntity (class_332 context, Quaternionf rotation) {
        float renderHeight;
        if (this.target.method_18381(class_4050.field_18076) >= this.target.method_17682() * 0.6) {
            renderHeight = this.target.method_18381(this.target.method_18376()) + 0.5f;
            if (renderHeight < 1f) renderHeight = 1f;
        }
        else renderHeight = this.target.method_18381(this.target.method_18376()) + 0.8f;

        context.method_44379(OFFSET_X, OFFSET_Y, OFFSET_X + FRAME_LENGTH, OFFSET_Y + FRAME_LENGTH);
        this.drawEntity(
            context,
            OFFSET_X,
            OFFSET_Y - 50,
            OFFSET_X + FRAME_LENGTH,
            OFFSET_Y + FRAME_LENGTH,
            30,
            new Vector3f(0f, renderHeight, 0f),
            rotation,
            this.target
        );
        context.method_44380();
    }

    private void drawEntity (
        class_332 drawer,
        int x1,
        int y1,
        int x2,
        int y2,
        float scale,
        Vector3f translation,
        Quaternionf rotation,
        class_1309 entity
    ) {
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897<? super class_1309, ?> entityRenderer = entityRenderDispatcher.method_3953(entity);
        class_10017 state = entityRenderer.method_62425(entity, 1.0F);
        state.field_58169 = null;
        state.field_53335 = false;
        state.field_53338 = null;
        state.field_61821 = 0;
        state.field_61820 = class_765.field_32767;
        ((IMixinEntityRenderState)state).provi_Health$setShouldRenderHealth(false);
        drawer.method_70856(state, scale, translation, rotation, null, x1, y1, x2, y2);
    }
}
