package com.provismet.provihealth.mixin;

import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.hud.ElementRegistry;
import com.provismet.provihealth.interfaces.IMixinEntityRenderState;
import com.provismet.provihealth.interfaces.IMixinLivingEntity;
import com.provismet.provihealth.util.Visibility;
import com.provismet.provihealth.world.EntityHealthBar;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_897.class)
public abstract class EntityRendererMixin {
    @Shadow @Final
    private class_327 textRenderer;

    @Shadow @Final
    protected class_898 dispatcher;

    @Shadow
    protected abstract boolean hasLabel (class_1297 entity, double squaredDistanceToCamera);

    @Inject(method="renderLabelIfPresent", at=@At("HEAD"), cancellable=true)
    private void cancelLabel (class_10017 state, class_4587 matrices, class_11659 queue, class_12075 cameraRenderState, CallbackInfo info) {
        if (Options.overrideLabels &&  ((IMixinEntityRenderState)state).provi_Health$shouldRenderHealth()) info.cancel();
    }

    @Inject(method="render", at=@At("HEAD"))
    private void addHealthBar (class_10017 state, class_4587 matrices, class_11659 queue, class_12075 cameraState, CallbackInfo info) {
        EntityHealthBar.render(state, matrices, queue, cameraState.field_63081, this.textRenderer);
    }

    @Inject(method="updateRenderState", at=@At("HEAD"))
    private void modifyRenderState (class_1297 entity, class_10017 state, float tickDelta, CallbackInfo info) {
        if (entity instanceof class_1309 living) { // Mixin here instead of LivingEntityRenderer because some mods have mobs that bypass it.
            IMixinEntityRenderState mixinState = (IMixinEntityRenderState)state;

            mixinState.provi_Health$setHealth(((IMixinLivingEntity)living).provi_Health$getHealthContainer());
            if (mixinState.provi_Health$getHealth() == null) { // This can only occur if the mob is rendered before its first tick.
                mixinState.provi_Health$setShouldRenderHealth(false);
                mixinState.provi_Health$setShouldRenderLabel(false);
                mixinState.provi_Health$setIsLiving(false);
                return;
            }

            mixinState.provi_Health$getHealth().lerp(tickDelta);
            mixinState.provi_Health$setShouldRenderHealth(Options.shouldRenderHealthFor(living));
            mixinState.provi_Health$setIsLiving(true);
            mixinState.provi_Health$setShouldRenderLabel(this.hasLabel(entity, state.field_53332));

            if (entity.method_5476() != null) mixinState.provi_Health$setLabel(entity.method_5476());
            else mixinState.provi_Health$setLabel(entity.method_5477());

            mixinState.provi_Health$setTitles(ElementRegistry.getTitle(living, true, false));

            // If another valid entity is riding this one, don't render a healthbar.
            if ((living.method_5782() &&
                living.method_31483() instanceof class_1309 livingRider &&
                !Options.isBlacklisted(livingRider, Options.BarType.WORLD)) ||
                living == class_310.method_1551().field_1724 ||
                !Visibility.isVisible(living)
            ) {
                mixinState.provi_Health$setShouldRenderHealth(false);
            }

            mixinState.provi_Health$setMountHealth(((IMixinLivingEntity)living).provi_Health$getMountHealthContainer());
            if (mixinState.provi_Health$getMountHealth() != null) {
                mixinState.provi_Health$getMountHealth().lerp(tickDelta);
            }

            if (living.method_5781() != null) mixinState.provi_Health$setTeamColour(living.method_5781().method_1202().method_532());
            else mixinState.provi_Health$setTeamColour(null);
        }
    }
}
