package com.provismet.provihealth.mixin;

import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.particle.TextParticleRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_11938;
import net.minecraft.class_11943;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_702;

@Mixin(class_702.class)
public abstract class ParticleManagerMixin {
    @Shadow @Final
    private Map<class_3999, class_11938<?>> particles;

    @Inject(method = "createParticleRenderer", at = @At("HEAD"), cancellable = true)
    private void addCustomRenderer (class_3999 textureSheet, CallbackInfoReturnable<class_11938<?>> cir) {
        if (textureSheet == TextParticleRenderer.PARTICLE_TEXTURE_SHEET) {
            cir.setReturnValue(new TextParticleRenderer((class_702)(Object)this));
        }
    }

    @Inject(method = "addToBatch", at = @At("HEAD"))
    private void addCustom (class_11943 batch, class_4604 frustum, class_4184 camera, float tickProgress, CallbackInfo info) {
        class_11938<?> particleRenderer = this.particles.get(TextParticleRenderer.PARTICLE_TEXTURE_SHEET);
        if (particleRenderer != null && !particleRenderer.method_74284()) {
            batch.method_74318(particleRenderer.method_74276(frustum, camera, tickProgress));
        }
    }
}
