package com.provismet.provihealth.particle;

import com.provismet.lilylib.util.MoreMath;
import com.provismet.provihealth.config.Options;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_765;

public class HealthParticle extends class_3940 {
    private final String text;
    private final float rotationSpeed;
    private final float maxScale;
    private final int textColour;

    private float prevScale;

    protected HealthParticle (class_638 clientWorld, double x, double y, double z, HealthParticleEffect particleEffect, class_4002 provider) {
        super(clientWorld, x, y, z, provider.method_74304());

        this.field_62633 = particleEffect.colour().x();
        this.field_62634 = particleEffect.colour().y();
        this.field_62635 = particleEffect.colour().z();
        this.field_17867 = 0f;
        this.prevScale = 0f;
        this.field_62636 = particleEffect.alpha();
        this.textColour = particleEffect.textColour();
        this.text = particleEffect.text();
        this.field_3847 = 40;

        this.rotationSpeed = (float)Math.toRadians((this.field_3840.method_43058() * 1.5 + 0.5) * (this.field_3840.method_43056() ? 10 : -10));
        this.maxScale = particleEffect.scale();

        final double sign = this.field_3840.method_43056() ? 1 : -1;
        final MoreMath.RightAngledTriangle triangle = new MoreMath.RightAngledTriangle(new class_243(this.field_3874, this.field_3854, this.field_3871), class_310.method_1551().field_1724.method_33571());

        switch (Options.particleType) {
            case RISING:
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854, this.field_3871 + 0.5 * triangle.sine() * sign);
                this.field_3852 = 0;
                this.field_3869 = 0.1;
                this.field_3850 = 0;
                this.field_28786 = 0.85f;
                break;

            case GRAVITY:
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854 + this.field_3840.method_43058() * 0.5, this.field_3871 + 0.5 * triangle.sine() * sign);
                double velBonus = this.field_3840.method_43058() * 0.025 + 0.05;
                this.field_3852 = velBonus * -triangle.cosine() * sign;
                this.field_3869 = 0.125;
                this.field_3850 = velBonus * triangle.sine() * sign;
                break;

            case STATIC:
                this.method_3063(this.field_3874 + 0.5 * -triangle.cosine() * sign, this.field_3854 + this.field_3840.method_43058() * 0.75, this.field_3871 + 0.5 * triangle.sine() * sign);
                this.field_3852 = 0;
                this.field_3869 = 0;
                this.field_3850 = 0;
                break;

            default:
                break;
        }

        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;

        this.field_3851.method_8466(
            TextParticleEffect.fromHealthParticleEffect(particleEffect),
            true,
            true,
            this.field_3874, this.field_3854, this.field_3871,
            this.field_3852, this.field_3869, this.field_3850
        );
    }

    @Override
    public void method_3070 () {
        super.method_3070();
        this.prevScale = this.field_17867;

        if (this.field_3866 > this.field_3847 / 2) this.field_17867 -= this.maxScale / (this.field_3847 / 2f);
        else if (this.field_17867 < this.maxScale) this.field_17867 += this.maxScale / 5f;

        this.field_62638 = this.field_62637;
        this.field_62637 += this.rotationSpeed;

        if (Options.particleType == Options.DamageParticleType.GRAVITY) {
            if (this.field_3845) {
                this.field_3852 = 0;
                this.field_3869 = 0;
                this.field_3850 = 0;
            }
            else this.field_3869 -= 0.025;
        }
    }

    @Override
    protected class_11941 method_74255 () {
        return class_11941.field_62641;
    }

    @Override
    public int method_3068 (float tint) {
        return class_765.method_23687(15, 15);
    }

    public String getText () {
        return this.text;
    }

    public int getColour () {
        return this.textColour;
    }

    @Override
    public float method_18132 (float tickDelta) {
        return class_3532.method_16439(tickDelta, this.prevScale, this.field_17867);
    }

    public class_243 getPos () {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    public class_243 getPrevPos () {
        return new class_243(this.field_3858, this.field_3838, this.field_3856);
    }

    public static class Factory implements class_707<HealthParticleEffect> {
        private final class_4002 spriteProvider;

        public Factory (class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        public class_703 createParticle (HealthParticleEffect particleEffect, class_638 clientWorld, double x, double y, double z, double velX, double velY, double velZ, class_5819 random) {
            HealthParticle textParticle = new HealthParticle(clientWorld, x, y, z, particleEffect, this.spriteProvider);
            textParticle.method_74306(this.spriteProvider);
            return textParticle;
        }

    }
}
