package com.provismet.provihealth.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record TextParticleEffect (float scale, int textColour, String text) implements class_2394 {
    private final static Codec<String> TEXT_CODEC = Codec.string(1, 8).validate(text -> {
        try {
            Integer.valueOf(text);
            return DataResult.success(text);
        } catch (Exception e) {
            return DataResult.error(() -> "Text must be an integer: " + text);
        }
    });

    public static final MapCodec<TextParticleEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
                class_5699.field_34387.fieldOf("scale").forGetter(effect -> effect.scale),
                class_5699.method_48766(0, 0xFFFFFF).fieldOf("text_colour").forGetter(effect -> effect.textColour),
                TEXT_CODEC.fieldOf("text").forGetter(effect -> effect.text))
            .apply(instance, TextParticleEffect::new)
    );

    public static final class_9139<class_9129, TextParticleEffect> PACKET_CODEC = class_9139.method_56436(
        class_9135.field_48552,
        effect -> effect.scale,
        class_9135.field_49675,
        effect -> effect.textColour,
        class_9135.method_56364(8),
        effect -> effect.text,
        TextParticleEffect::new
    );

    public static TextParticleEffect fromHealthParticleEffect (HealthParticleEffect effect) {
        return new TextParticleEffect(effect.scale(), effect.textColour(), effect.text());
    }

    @Override
    public class_2396<TextParticleEffect> method_10295 () {
        return Particles.TEXT_PARTICLE;
    }
}
