package com.provismet.provihealth.util;

import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_9848;
import org.joml.Vector3f;

public class ColourHelper {
    public static Vector3f lerpBarColour (float percentage, Vector3f start, Vector3f end, boolean shouldGradient) {
        if (shouldGradient) {
            Vector3f colour = new Vector3f();
            colour.x = class_3532.method_16439(percentage, end.x, start.x);
            colour.y = class_3532.method_16439(percentage, end.y, start.y);
            colour.z = class_3532.method_16439(percentage, end.z, start.z);
            return colour;
        }
        else return start;
    }

    public static int lerpBarColour (float percentage, int start, int end, boolean shouldGradient) {
        Vector3f lerpedVector = lerpBarColour(percentage, class_243.method_24457(start).method_46409(), class_243.method_24457(end).method_46409(), shouldGradient);
        int red = (int)(lerpedVector.x * 255) << 16;
        int green = (int)(lerpedVector.y * 255) << 8;
        int blue = (int)(lerpedVector.z * 255);
        return class_9848.method_61334(red | green | blue);
    }
}
