package com.provismet.provihealth.util;

import com.provismet.provihealth.config.Options;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

public interface HealthCalculator {
    @Nullable
    static HealthContainer getRecursiveMountHealth (class_1297 rider, @Nullable Options.BarType barType) {
        if (!rider.method_5765()) return null;

        float vehicleHealthDeep = 0f;
        float vehicleMaxHealthDeep = 0f;

        class_1297 currentMount = rider.method_5854();
        while (currentMount != null) {
            if (currentMount instanceof class_1309 currentLiving && !Options.isBlacklisted(currentMount, barType)) {
                vehicleHealthDeep += currentLiving.method_6032();
                vehicleMaxHealthDeep += currentLiving.method_6063();
            }
            currentMount = currentMount.method_5854();
        }

        if (vehicleMaxHealthDeep == 0f) return null;
        return new HealthContainer(vehicleHealthDeep, vehicleMaxHealthDeep);
    }
}
