package com.provismet.provihealth.world;

import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.config.Options.SeeThroughText;
import com.provismet.provihealth.interfaces.IMixinEntityRenderState;
import com.provismet.provihealth.util.HealthContainer;
import org.joml.Quaternionf;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_327.class_6415;
import net.minecraft.class_4587;
import net.minecraft.class_765;
import net.minecraft.class_8012;

public class EntityHealthBar {
    public static final float TEXTURE_SIZE = 64;
    private static final class_2960 BARS = ProviHealthClient.identifier("textures/gui/healthbars/in_world.png");
    private static final int LIGHT = class_765.method_23687(15, 15);
    private static final int BACKGROUND_BAR_INDEX = 1;
    private static final int FOREGROUND_BAR_INDEX = 0;

    public static void render (class_10017 state, class_4587 matrices, class_11659 queue, Quaternionf rotation, class_327 textRenderer) {
        IMixinEntityRenderState mixinState = (IMixinEntityRenderState)state;
        if (!mixinState.provi_Health$isLiving() || !mixinState.provi_Health$shouldRenderHealth() || !class_310.method_1498()) return;

        matrices.method_22903();
        matrices.method_46416(0f, state.field_53330 + 0.45f - (0.003f / Options.worldHealthBarScale) + Options.worldOffsetY, 0f);
        matrices.method_22905(Options.worldHealthBarScale, Options.worldHealthBarScale, Options.worldHealthBarScale);
        matrices.method_46416(0f, (mixinState.provi_Health$shouldRenderLabel() && !Options.overrideLabels && !(state.field_53333 || (state instanceof class_10042 livingState && livingState.field_53461)) ? 0.02f + 0.3f / Options.worldHealthBarScale : 0f), 0f);
        matrices.method_22907(rotation); // This is the problem.

        renderBars(mixinState, matrices, queue, false);
        if (mixinState.provi_Health$getMountHealth() != null && mixinState.provi_Health$getMountHealth().getMax() > 0) {
            matrices.method_22903();
            matrices.method_46416(0f, -1f * (7f / TEXTURE_SIZE), 0f);
            renderBars(mixinState, matrices, queue, true);
            matrices.method_22909();
        }

        // Health Text
        if (Options.showTextInWorld) {
            matrices.method_22903();
            matrices.method_22905(0.01f, -0.01f, 0.01f);
            final String healthString = String.format("%d/%d", Math.round(mixinState.provi_Health$getHealth().getCurrent()), Math.round(mixinState.provi_Health$getHealth().getMax()));
            final float lineHeight = 9;

            List<class_2561> titles = List.of(); // initialise an empty list
            if (Options.worldTitles) titles = mixinState.provi_Health$getTitles();

            if (Options.overrideLabels) {
                final class_2561 targetName = EntityHealthBar.getName(state);
                final float targetNameWidth = textRenderer.method_27525(targetName);

                // 0 is in the centre.
                final float leftmost = -50f;
                final float rightmost = -leftmost;

                float healthX = rightmost - textRenderer.method_1727(healthString);
                final float healthY = -lineHeight;
                float nameX = leftmost;
                float nameY = -lineHeight;
                boolean wrapLines = targetNameWidth - rightmost > healthX - 2f;

                if (wrapLines) {
                    healthX = (healthX - 50) / 2f;
                    nameX = -targetNameWidth / 2f;
                    nameY -= lineHeight;
                }

                if (mixinState.provi_Health$shouldRenderLabel() && !state.field_53334 && Options.seeThroughTextType != SeeThroughText.NONE) {
                    if (Options.seeThroughTextType == SeeThroughText.STANDARD) {
                        if (Options.worldShadows) {
                            EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX + 1, nameY + 1, healthX + 1, healthY + 1, lineHeight, 1, 0xFF404040, false, matrices, queue, class_6415.field_33993, LIGHT);
                        }

                        matrices.method_46416(0, 0, 0.03f);
                        EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, healthY, lineHeight, 0, class_8012.field_42973, false, matrices, queue, class_6415.field_33994, LIGHT);
                    }
                    else { // SeeThroughText.FULL
                        EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, healthY, lineHeight, 0, class_8012.field_42973, Options.worldShadows, matrices, queue, class_6415.field_33994, LIGHT);
                    }
                }
                else {
                    EntityHealthBar.renderFullText(textRenderer, targetName, healthString, titles, nameX, nameY, healthX, healthY, lineHeight, 0, class_8012.field_42973, Options.worldShadows, matrices, queue, class_6415.field_33993, LIGHT);
                }
            }
            else {
                queue.method_73478(matrices, -(textRenderer.method_1727(healthString)) / 2f, -lineHeight, class_2561.method_43470(healthString).method_30937(), Options.worldShadows, class_6415.field_33993, LIGHT, class_8012.field_42973, 0, 0);

                float titleX;
                float titleY = -lineHeight;
                for (class_2561 title : titles) {
                    titleX = -textRenderer.method_27525(title) / 2f;
                    titleY -= lineHeight;
                    queue.method_73478(matrices, titleX, titleY, title.method_30937(), Options.worldShadows, class_6415.field_33993, LIGHT, 0xFFFFFFFF, 0, 0);
                }
            }
            matrices.method_22909();
        }

        matrices.method_22909();
    }

    private static void renderFullText (class_327 textRenderer, class_2561 name, String health, List<class_2561> titles, float nameX, float nameY, float healthX, float healthY, float titleLineHeight, float titleLineOffset, int colour, boolean shadow, class_4587 matrices, class_11659 queue, class_6415 layerType, int light) {
        queue.method_73478(matrices, nameX, nameY, name.method_30937(), shadow, layerType, light, colour, 0, 0);
        queue.method_73478(matrices, healthX, healthY, class_2561.method_43470(health).method_30937(), shadow, layerType, light, colour, 0, 0);

        float titleX;
        float titleY = nameY;
        for (class_2561 title : titles) {
            titleX = titleLineOffset - (textRenderer.method_27525(title) / 2f);
            titleY -= titleLineHeight;
            queue.method_73478(matrices, titleX, titleY, title.method_30937(), shadow, layerType, light, colour, 0, 0);
        }
    }

    private static class_2561 getName (class_10017 state) {
        if (state instanceof class_10055 playerState && playerState.field_53461) return class_2561.method_43471("entity.provihealth.unknownPlayer");
        return ((IMixinEntityRenderState)state).provi_Health$getLabel();
    }

    private static void renderBars (IMixinEntityRenderState state, class_4587 matrices, class_11659 queue, boolean isMount) {
        Optional<Integer> teamColour = Optional.ofNullable(state.provi_Health$getTeamColour());
        HealthContainer container = isMount ? state.provi_Health$getMountHealth() : state.provi_Health$getHealth();

        queue.method_73483(
            matrices,
            class_1921.method_23028(BARS),
            new RenderableHealthBar(
                teamColour,
                BACKGROUND_BAR_INDEX,
                1f,
                isMount
            )
        );
        queue.method_73483(
            matrices,
            class_1921.method_23028(BARS),
            new RenderableHealthBar(
                teamColour,
                FOREGROUND_BAR_INDEX,
                container.getLerped() / container.getMax(),
                isMount
            )
        );
    }
}
