package com.provismet.provihealth.world;

import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.util.ColourHelper;
import org.joml.Vector3f;

import java.util.Optional;
import net.minecraft.class_11659;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public record RenderableHealthBar (Optional<Integer> teamColour, int index, float percentage, boolean isMount) implements class_11659.class_11660 {
    @Override
    public void render (class_4587.class_4665 matrix, class_4588 vertexConsumer) {
        float clampedPercentage = class_3532.method_15363(this.percentage, 0f, 1f);
        float healthPercentage = clampedPercentage; // Just to decouple the colouring from the background image.
        if (this.index == 1) clampedPercentage = 1f;
        if (this.isMount) clampedPercentage = class_3532.method_16439(clampedPercentage, 3f / EntityHealthBar.TEXTURE_SIZE, 61f / EntityHealthBar.TEXTURE_SIZE);

        // As of 1.21, the rendering was changed for whatever reason and the bars were facing in the wrong direction (which makes them invisible).
        // This method now renders them backwards because simply rotating them was causing even more issues.

        // All U and V values are a percentage.
        final float MIN_U = 1f - clampedPercentage; // Leftmost pixel
        final float MIN_V = ((this.index * 12f) / EntityHealthBar.TEXTURE_SIZE) + (this.isMount ? 7f / EntityHealthBar.TEXTURE_SIZE : 0f); // Topmost pixel
        final float MAX_U = 1f; // Rightmost pixel
        final float MAX_V = MIN_V + (this.isMount ? 5f : 7f) / EntityHealthBar.TEXTURE_SIZE; // Bottommost pixel

        // X and Y are block coordinates relative to the matrix shenanigans.
        final float MAX_X = -0.5f; // Pushes the bar half a block to the left, centering it.
        final float MIN_X = MAX_X + clampedPercentage;
        final float MIN_Y = 0f;
        final float MAX_Y = -1f * ((this.isMount ? 5f : 7f) / EntityHealthBar.TEXTURE_SIZE); // Mount bar is 5 pixels tall, Health bar is 7 pixels tall.

        final float Z = (float)this.index * -0.0001f;

        Vector3f colour;
        if (!Options.tintBackground && this.index == 1) {
            colour = Options.WHITE;
        }
        else if (Options.useTeamColours && this.teamColour.isPresent()) {
            colour = class_243.method_24457(this.teamColour.get()).method_46409();
        }
        else {
            colour = ColourHelper.lerpBarColour(healthPercentage, Options.unpackedStartWorld, Options.unpackedEndWorld, Options.worldGradient);
        }

        int maxLight = 0xF000F0;
        vertexConsumer.method_56824(matrix, MIN_X, MIN_Y, Z).method_22913(MIN_U, MIN_V).method_60803(maxLight).method_22915(colour.x, colour.y, colour.z, 1f); // Top-Left
        vertexConsumer.method_56824(matrix, MAX_X, MIN_Y, Z).method_22913(MAX_U, MIN_V).method_60803(maxLight).method_22915(colour.x, colour.y, colour.z, 1f); // Top-Right
        vertexConsumer.method_56824(matrix, MAX_X, MAX_Y, Z).method_22913(MAX_U, MAX_V).method_60803(maxLight).method_22915(colour.x, colour.y, colour.z, 1f); // Bottom-Right
        vertexConsumer.method_56824(matrix, MIN_X, MAX_Y, Z).method_22913(MIN_U, MAX_V).method_60803(maxLight).method_22915(colour.x, colour.y, colour.z, 1f); // Bottom-Left
    }
}
