/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core;

import com.tttsaurus.fluxloading.FluxLoading;
import com.tttsaurus.fluxloading.FluxLoadingConfig;
import com.tttsaurus.fluxloading.core.FluxLoadingAPI;
import com.tttsaurus.fluxloading.core.accessor.ChunkProviderClientAccessor;
import com.tttsaurus.fluxloading.core.animation.SmoothDamp;
import com.tttsaurus.fluxloading.core.network.FluxLoadingNetwork;
import com.tttsaurus.fluxloading.core.raycast.FrustumChunkRayCastHelper;
import com.tttsaurus.fluxloading.core.raycast.Ray;
import com.tttsaurus.fluxloading.core.render.CommonBuffers;
import com.tttsaurus.fluxloading.core.render.RenderUtils;
import com.tttsaurus.fluxloading.core.render.Texture2D;
import com.tttsaurus.fluxloading.core.render.shader.Shader;
import com.tttsaurus.fluxloading.core.render.shader.ShaderLoader;
import com.tttsaurus.fluxloading.core.render.shader.ShaderProgram;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.time.StopWatch;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public final class FluxLoadingManager {
    private static boolean active = false;
    private static ShaderProgram shaderProgram = null;
    private static FloatBuffer vertexBuffer;
    private static boolean screenshotToggle;
    private static boolean forceLoadingTitle;
    private static Texture2D texture;
    private static BufferedImage screenshot;
    private static boolean movementLocked;
    private static boolean lockPosFetched;
    private static double lockX;
    private static double lockY;
    private static double lockZ;
    private static boolean waitChunksToLoad;
    private static boolean finishChunkLoading;
    private static boolean countingChunkLoaded;
    private static int chunkLoadedNum;
    private static int targetChunkNum;
    private static boolean startCalcTargetChunkNum;
    private static boolean targetChunkNumCalculated;
    private static boolean chunkLoadingTitle;
    private static boolean chunkLoadingPercentage;
    private static int chunkRayCastTestRayDis;
    private static double extraWaitTime;
    private static double fadeOutDuration;
    private static StopWatch fadeOutStopWatch;
    private static SmoothDamp smoothDamp;
    private static double prevFadeOutTime;
    private static boolean debug;
    private static List<Ray> frustumRays;
    public static final Map<UUID, Vec3d> serverLockPos;

    public static boolean isActive() {
        return active;
    }

    public static void setActive(boolean flag) {
        active = flag;
    }

    public static void prepareScreenshot() {
        screenshotToggle = true;
    }

    public static boolean isForceLoadingTitle() {
        return forceLoadingTitle;
    }

    public static void setForceLoadingTitle(boolean flag) {
        forceLoadingTitle = flag;
    }

    public static void setChunkLoadingTitle(boolean flag) {
        chunkLoadingTitle = flag;
    }

    public static void setChunkLoadingPercentage(boolean flag) {
        chunkLoadingPercentage = flag;
    }

    public static boolean isTextureAvailable() {
        return texture != null;
    }

    public static void updateTexture(Texture2D tex) {
        if (texture != null) {
            texture.dispose();
        }
        texture = tex;
    }

    public static boolean isMovementLocked() {
        return movementLocked;
    }

    public static void resetMovementLocked() {
        movementLocked = false;
        lockPosFetched = false;
        lockX = 0.0;
        lockY = 0.0;
        lockZ = 0.0;
    }

    public static boolean isWaitChunksToLoad() {
        return waitChunksToLoad;
    }

    public static void setWaitChunksToLoad(boolean flag) {
        waitChunksToLoad = flag;
    }

    public static void setFinishChunkLoading(boolean flag) {
        finishChunkLoading = flag;
    }

    public static boolean isCountingChunkLoaded() {
        return countingChunkLoaded;
    }

    public static void setCountingChunkLoaded(boolean flag) {
        countingChunkLoaded = flag;
    }

    public static int getChunkLoadedNum() {
        return chunkLoadedNum;
    }

    public static void incrChunkLoadedNum() {
        ++chunkLoadedNum;
    }

    public static void resetChunkLoadedNum() {
        chunkLoadedNum = 0;
    }

    public static boolean isStartCalcTargetChunkNum() {
        return startCalcTargetChunkNum;
    }

    public static void setStartCalcTargetChunkNum(boolean flag) {
        startCalcTargetChunkNum = flag;
    }

    public static boolean isTargetChunkNumCalculated() {
        return targetChunkNumCalculated;
    }

    public static void resetTargetChunkNumCalculated() {
        targetChunkNumCalculated = false;
    }

    public static int getTargetChunkNum() {
        return targetChunkNum;
    }

    public static void resetTargetChunkNum() {
        targetChunkNum = 0;
    }

    public static void setChunkRayCastTestRayDis(int dis) {
        chunkRayCastTestRayDis = dis;
    }

    public static void setExtraWaitTime(double time) {
        extraWaitTime = time;
    }

    public static void setFadeOutDuration(double time) {
        fadeOutDuration = time;
    }

    public static void startFadeOutTimer() {
        fadeOutStopWatch = new StopWatch();
        fadeOutStopWatch.start();
        smoothDamp = new SmoothDamp(0.0f, 1.0f, (float)fadeOutDuration);
        prevFadeOutTime = 0.0;
    }

    public static void resetFadeOutTimer() {
        if (fadeOutStopWatch != null) {
            fadeOutStopWatch.stop();
            fadeOutStopWatch = null;
        }
    }

    public static void setDebug(boolean flag) {
        debug = flag;
    }

    public static void calcTargetChunkNum() {
        Minecraft.func_71410_x().func_152344_a(() -> {
            ChunkProviderClient chunkProvider = Minecraft.func_71410_x().field_71441_e.func_72863_F();
            Long2ObjectMap<Chunk> loadedChunks = ChunkProviderClientAccessor.getLoadedChunks(chunkProvider);
            Vec3d camPos = RenderUtils.getCameraPos();
            ClippingHelper frustumHelper = ClippingHelperImpl.func_78558_a();
            Frustum viewFrustum = new Frustum(frustumHelper);
            viewFrustum.func_78547_a(camPos.field_72450_a, camPos.field_72448_b, camPos.field_72449_c);
            ArrayList<Chunk> visibleChunks = new ArrayList<Chunk>();
            for (Chunk chunk : loadedChunks.values()) {
                int chunkX = chunk.field_76635_g;
                double minX = chunkX * 16;
                double minY = 0.0;
                int chunkZ = chunk.field_76647_h;
                double minZ = chunkZ * 16;
                double maxX = minX + 16.0;
                double maxY = 256.0;
                double maxZ = minZ + 16.0;
                AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                if (!viewFrustum.func_78546_a(box) || chunk.func_76621_g()) continue;
                visibleChunks.add(chunk);
            }
            FluxLoading.logger.info("Chunk count from ChunkProviderClient: " + loadedChunks.size());
            FluxLoading.logger.info("Visible chunks from player's perspective: " + visibleChunks.size());
            frustumRays = FrustumChunkRayCastHelper.getRaysFromFrustum(camPos, ClippingHelperImpl.func_78558_a(), 10, 10);
            targetChunkNum = FrustumChunkRayCastHelper.getChunkRayCastNum(frustumRays, visibleChunks, chunkRayCastTestRayDis);
            FluxLoading.logger.info("Visible chunks after frustum ray casting: " + targetChunkNum);
            targetChunkNumCalculated = true;
        });
    }

    public static void trySaveToLocal() {
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        if (server != null) {
            File worldSaveDir = new File("saves/" + server.func_71270_I());
            if (screenshot != null) {
                RenderUtils.createPng(worldSaveDir, "last_screenshot", screenshot);
            }
        }
    }

    public static void tryReadFromLocal(String folderName) {
        Texture2D texture;
        File screenshot = new File("saves/" + folderName + "/last_screenshot.png");
        if (screenshot.exists() && (texture = RenderUtils.readPng(screenshot)) != null) {
            FluxLoadingManager.updateTexture(texture);
        }
    }

    private static void triggerShader() {
        GL20.glGetVertexAttrib((int)0, (int)34338, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        boolean enabled = CommonBuffers.INT_BUFFER_16.get(0) == 1;
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (boolean)false, (int)0, (FloatBuffer)vertexBuffer);
        GL11.glDrawArrays((int)4, (int)0, (int)3);
        if (enabled) {
            GL20.glEnableVertexAttribArray((int)0);
        } else {
            GL20.glDisableVertexAttribArray((int)0);
        }
    }

    private static void initShader() {
        if (shaderProgram == null) {
            Shader vertex = ShaderLoader.load("fluxloading:shaders/loading_screen_vertex.glsl", Shader.ShaderType.VERTEX);
            Shader frag = ShaderLoader.load("fluxloading:shaders/loading_screen_frag.glsl", Shader.ShaderType.FRAGMENT);
            shaderProgram = new ShaderProgram(vertex, frag);
            shaderProgram.setup();
            FluxLoading.logger.info(shaderProgram.getSetupDebugReport());
            shaderProgram.use();
            shaderProgram.setUniform("screenTexture", 1);
            shaderProgram.setUniform("percentage", Float.valueOf(0.0f));
            shaderProgram.setUniform("enableDissolving", FluxLoadingConfig.ENABLE_DISSOLVING_EFFECT);
            shaderProgram.setUniform("enableWaving", FluxLoadingConfig.ENABLE_WAVING_EFFECT);
            shaderProgram.setUniform("enableDarkOverlay", FluxLoadingConfig.ENABLE_DARK_OVERLAY);
            shaderProgram.unuse();
            vertexBuffer = ByteBuffer.allocateDirect(36).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertexBuffer.put(new float[]{-1.0f, -1.0f, 0.0f, 3.0f, -1.0f, 0.0f, -1.0f, 3.0f, 0.0f}).flip();
        }
    }

    public static void resetShader() {
        if (shaderProgram != null) {
            shaderProgram.use();
            shaderProgram.setUniform("percentage", Float.valueOf(0.0f));
            shaderProgram.unuse();
        }
    }

    public static void drawOverlay() {
        if (!FluxLoadingAPI.duringDefaultWorldLoadingPhase) {
            FluxLoadingAPI.duringDefaultWorldLoadingPhase = true;
        }
        FluxLoadingManager.drawOverlay(0.0);
    }

    private static void drawOverlay(double time) {
        FluxLoadingManager.initShader();
        boolean blend = GL11.glIsEnabled((int)3042);
        boolean depthTest = GL11.glIsEnabled((int)2929);
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GL11.glGetInteger((int)34016, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        int texUnit = CommonBuffers.INT_BUFFER_16.get(0);
        GlStateManager.func_179138_g((int)33985);
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        int texUnit1TextureID = CommonBuffers.INT_BUFFER_16.get(0);
        GlStateManager.func_179144_i((int)texture.getGlTextureID());
        GlStateManager.func_179138_g((int)texUnit);
        shaderProgram.use();
        if (time >= extraWaitTime) {
            double nowFadeOutTime = time - extraWaitTime;
            double delta = nowFadeOutTime - prevFadeOutTime;
            float percentage = smoothDamp.evaluate((float)delta);
            prevFadeOutTime = nowFadeOutTime;
            shaderProgram.setUniform("percentage", Float.valueOf(percentage));
        }
        FluxLoadingManager.triggerShader();
        shaderProgram.unuse();
        GL11.glGetInteger((int)34016, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        texUnit = CommonBuffers.INT_BUFFER_16.get(0);
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179144_i((int)texUnit1TextureID);
        GlStateManager.func_179138_g((int)texUnit);
        if (depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        if (blend) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
    }

    public static void tick() {
        for (Runnable runnable : FluxLoadingAPI.fluxLoadingTickListeners) {
            runnable.run();
        }
        ++FluxLoadingAPI.tickNum;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (active) {
            if (!FluxLoadingAPI.finishLoading && !movementLocked) {
                movementLocked = true;
                Minecraft.func_71410_x().field_71417_B.func_74373_b();
            }
            if (!finishChunkLoading) {
                if (!FluxLoadingAPI.duringExtraChunkLoadingPhase) {
                    FluxLoadingAPI.duringDefaultWorldLoadingPhase = false;
                    FluxLoadingAPI.duringExtraChunkLoadingPhase = true;
                }
                FluxLoadingManager.drawOverlay(0.0);
                if (chunkLoadingTitle) {
                    ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
                    String i18nText = I18n.func_135052_a((String)"fluxloading.loading_wait", (Object[])new Object[0]);
                    float width = RenderUtils.fontRenderer.func_78256_a(i18nText);
                    RenderUtils.renderText(i18nText, ((float)resolution.func_78326_a() - width) / 2.0f, (resolution.func_78328_b() - RenderUtils.fontRenderer.field_78288_b) / 2 + (chunkLoadingPercentage ? -10 : 0), 1.0f, Color.WHITE.getRGB(), true);
                    if (chunkLoadingPercentage && targetChunkNumCalculated) {
                        String text = String.format("%d/%d, %.1f", chunkLoadedNum, targetChunkNum, Float.valueOf((float)chunkLoadedNum / (float)targetChunkNum * 100.0f)) + "%";
                        width = RenderUtils.fontRenderer.func_78256_a(text);
                        RenderUtils.renderText(text, ((float)resolution.func_78326_a() - width) / 2.0f, (resolution.func_78328_b() - RenderUtils.fontRenderer.field_78288_b) / 2 + 10, 1.0f, Color.WHITE.getRGB(), true);
                    }
                }
            }
            if (fadeOutStopWatch != null) {
                double time = (double)fadeOutStopWatch.getNanoTime() / 1.0E9;
                if (!FluxLoadingAPI.duringExtraWaitPhase) {
                    FluxLoadingAPI.duringDefaultWorldLoadingPhase = false;
                    FluxLoadingAPI.duringExtraChunkLoadingPhase = false;
                    FluxLoadingAPI.duringExtraWaitPhase = true;
                }
                if (time >= extraWaitTime && !FluxLoadingAPI.duringFadingOutPhase) {
                    FluxLoadingAPI.duringExtraWaitPhase = false;
                    FluxLoadingAPI.duringFadingOutPhase = true;
                }
                if (time >= fadeOutDuration + extraWaitTime) {
                    FluxLoadingManager.resetFadeOutTimer();
                    texture.dispose();
                    FluxLoadingManager.resetShader();
                    FluxLoadingAPI.duringDefaultWorldLoadingPhase = false;
                    FluxLoadingAPI.duringExtraChunkLoadingPhase = false;
                    FluxLoadingAPI.duringExtraWaitPhase = false;
                    FluxLoadingAPI.duringFadingOutPhase = false;
                    FluxLoadingAPI.finishLoading = true;
                    if (movementLocked) {
                        FluxLoadingNetwork.requestPlayerLock(false);
                        Minecraft.func_71410_x().func_71381_h();
                        movementLocked = false;
                    }
                    FluxLoadingAPI.stopWatch.stop();
                    double timeMs = (double)FluxLoadingAPI.stopWatch.getNanoTime() / 1000000.0;
                    for (Runnable runnable : FluxLoadingAPI.fluxLoadingEndListeners) {
                        runnable.run();
                    }
                    FluxLoading.logger.info("Finished world flux loading process. Time taken: " + timeMs + " ms. Tick count: " + FluxLoadingAPI.tickNum);
                    active = false;
                    return;
                }
                FluxLoadingManager.drawOverlay(time);
            }
            if (!FluxLoadingAPI.finishLoading) {
                FluxLoadingManager.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (screenshotToggle) {
            screenshotToggle = false;
            Minecraft minecraft = Minecraft.func_71410_x();
            screenshot = ScreenShotHelper.func_186719_a((int)minecraft.field_71443_c, (int)minecraft.field_71440_d, (Framebuffer)minecraft.func_147110_a());
        }
        if (debug && frustumRays != null) {
            RenderUtils.storeCommonGlStates();
            for (Ray ray : frustumRays) {
                GlStateManager.func_179094_E();
                Vec3d camPos = RenderUtils.getWorldOffset();
                GlStateManager.func_179109_b((float)((float)(-camPos.field_72450_a + ray.pos.field_72450_a)), (float)((float)(-camPos.field_72448_b + ray.pos.field_72448_b)), (float)((float)(-camPos.field_72449_c + ray.pos.field_72449_c)));
                GlStateManager.func_179129_p();
                GlStateManager.func_179126_j();
                GlStateManager.func_179090_x();
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                GlStateManager.func_187441_d((float)3.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                buffer.func_181662_b(ray.dir.field_72450_a * 5.0, ray.dir.field_72448_b * 5.0, ray.dir.field_72449_c * 5.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            RenderUtils.restoreCommonGlStates();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null && movementLocked) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (!lockPosFetched) {
                lockPosFetched = true;
                lockX = player.field_70165_t;
                lockY = player.field_70163_u;
                lockZ = player.field_70161_v;
                FluxLoadingNetwork.requestPlayerLock(true);
            }
            player.field_71158_b.field_192832_b = 0.0f;
            player.field_71158_b.field_78902_a = 0.0f;
            player.field_71158_b.field_187255_c = false;
            player.field_71158_b.field_187256_d = false;
            player.field_71158_b.field_187257_e = false;
            player.field_71158_b.field_187258_f = false;
            player.field_71158_b.field_78901_c = false;
            player.field_71158_b.field_78899_d = false;
            player.field_70159_w = 0.0;
            player.field_70181_x = 0.0;
            player.field_70179_y = 0.0;
            player.func_70107_b(lockX, lockY, lockZ);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !serverLockPos.isEmpty()) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            ArrayList<UUID> outdated = new ArrayList<UUID>();
            for (Map.Entry<UUID, Vec3d> entry : serverLockPos.entrySet()) {
                UUID uuid = entry.getKey();
                EntityPlayerMP player = server.func_184103_al().func_177451_a(uuid);
                if (player == null) {
                    outdated.add(uuid);
                    continue;
                }
                Vec3d pos = entry.getValue();
                player.field_71135_a.func_147364_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player.field_70177_z, player.field_70125_A);
            }
            for (UUID uuid : outdated) {
                serverLockPos.remove(uuid);
            }
        }
    }

    static {
        screenshotToggle = false;
        forceLoadingTitle = false;
        texture = null;
        screenshot = null;
        movementLocked = false;
        lockPosFetched = false;
        waitChunksToLoad = true;
        finishChunkLoading = false;
        countingChunkLoaded = false;
        chunkLoadedNum = 0;
        targetChunkNum = 0;
        startCalcTargetChunkNum = false;
        targetChunkNumCalculated = false;
        chunkLoadingTitle = false;
        chunkLoadingPercentage = false;
        chunkRayCastTestRayDis = 512;
        extraWaitTime = 0.5;
        fadeOutDuration = 1.0;
        fadeOutStopWatch = null;
        smoothDamp = null;
        prevFadeOutTime = 0.0;
        debug = false;
        frustumRays = null;
        serverLockPos = new HashMap<UUID, Vec3d>();
    }
}

