/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.util;

import com.tttsaurus.fluxloading.core.function.ActionBase;
import com.tttsaurus.fluxloading.core.function.Action_1Param;
import com.tttsaurus.fluxloading.core.function.Action_2Param;
import com.tttsaurus.fluxloading.core.function.Func;
import com.tttsaurus.fluxloading.core.function.FuncBase;
import com.tttsaurus.fluxloading.core.function.Func_1Param;
import com.tttsaurus.fluxloading.core.util.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

public final class AccessorUnreflector {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    @Nullable
    private static Field findDeclaredField(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getDeclaredField(obfFieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    @Nullable
    private static Field findDeclaredField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    private static Field findField(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getField(obfFieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    @Nullable
    private static Field findField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    private static FuncBase unreflectGetter(Field field) {
        if (field.getType().isPrimitive()) {
            return AccessorUnreflector.unreflectGetterHelper(field, TypeUtils.toWrappedPrimitive(field.getType()), field.getDeclaringClass());
        }
        return AccessorUnreflector.unreflectGetterHelper(field, field.getType(), field.getDeclaringClass());
    }

    @Nullable
    private static <TReturn, TOwner> FuncBase unreflectGetterHelper(Field field, Class<TReturn> clazz1, Class<TOwner> clazz2) {
        field.setAccessible(true);
        FuncBase getter = null;
        try {
            final MethodHandle handle = lookup.unreflectGetter(field);
            getter = Modifier.isStatic(field.getModifiers()) ? new Func<TReturn>(){

                @Override
                public TReturn invoke() {
                    try {
                        return handle.invoke();
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            } : new Func_1Param<TReturn, TOwner>(){

                @Override
                public TReturn invoke(TOwner arg0) {
                    try {
                        return handle.invoke(arg0);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
        return getter;
    }

    private static ActionBase unreflectSetter(Field field) {
        if (field.getType().isPrimitive()) {
            return AccessorUnreflector.unreflectSetterHelper(field, TypeUtils.toWrappedPrimitive(field.getType()), field.getDeclaringClass());
        }
        return AccessorUnreflector.unreflectSetterHelper(field, field.getType(), field.getDeclaringClass());
    }

    @Nullable
    private static <TField, TOwner> ActionBase unreflectSetterHelper(Field field, Class<TField> clazz1, Class<TOwner> clazz2) {
        field.setAccessible(true);
        ActionBase setter = null;
        try {
            final MethodHandle handle = lookup.unreflectSetter(field);
            setter = Modifier.isStatic(field.getModifiers()) ? new Action_1Param<TField>(){

                @Override
                public void invoke(TField arg0) {
                    try {
                        handle.invoke(arg0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } : new Action_2Param<TOwner, TField>(){

                @Override
                public void invoke(TOwner arg0, TField arg1) {
                    try {
                        handle.invoke(arg0, arg1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
        return setter;
    }

    @Nullable
    public static FuncBase getDeclaredFieldGetter(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = AccessorUnreflector.findDeclaredField(clazz, fieldName, obfFieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectGetter(field);
    }

    @Nullable
    public static FuncBase getDeclaredFieldGetter(Class<?> clazz, String fieldName) {
        Field field = AccessorUnreflector.findDeclaredField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectGetter(field);
    }

    @Nullable
    public static FuncBase getFieldGetter(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = AccessorUnreflector.findField(clazz, fieldName, obfFieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectGetter(field);
    }

    @Nullable
    public static FuncBase getFieldGetter(Class<?> clazz, String fieldName) {
        Field field = AccessorUnreflector.findField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectGetter(field);
    }

    @Nullable
    public static ActionBase getDeclaredFieldSetter(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = AccessorUnreflector.findDeclaredField(clazz, fieldName, obfFieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectSetter(field);
    }

    @Nullable
    public static ActionBase getDeclaredFieldSetter(Class<?> clazz, String fieldName) {
        Field field = AccessorUnreflector.findDeclaredField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectSetter(field);
    }

    @Nullable
    public static ActionBase getFieldSetter(Class<?> clazz, String fieldName, String obfFieldName) {
        Field field = AccessorUnreflector.findField(clazz, fieldName, obfFieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectSetter(field);
    }

    @Nullable
    public static ActionBase getFieldSetter(Class<?> clazz, String fieldName) {
        Field field = AccessorUnreflector.findField(clazz, fieldName);
        if (field == null) {
            return null;
        }
        return AccessorUnreflector.unreflectSetter(field);
    }
}

