/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core;

import com.tttsaurus.fluxloading.FluxLoading;
import com.tttsaurus.fluxloading.FluxLoadingConfig;
import com.tttsaurus.fluxloading.core.render.CommonBuffers;
import com.tttsaurus.fluxloading.core.render.shader.Shader;
import com.tttsaurus.fluxloading.core.render.shader.ShaderLoader;
import com.tttsaurus.fluxloading.core.render.shader.ShaderProgram;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public final class ShaderResources {
    private static ShaderProgram shaderProgram = null;
    private static FloatBuffer vertexBuffer;

    public static ShaderProgram getShaderProgram() {
        return shaderProgram;
    }

    public static void triggerShader() {
        GL20.glGetVertexAttrib((int)0, (int)34338, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        boolean enabled = CommonBuffers.INT_BUFFER_16.get(0) == 1;
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (boolean)false, (int)0, (FloatBuffer)vertexBuffer);
        GL11.glDrawArrays((int)4, (int)0, (int)3);
        if (enabled) {
            GL20.glEnableVertexAttribArray((int)0);
        } else {
            GL20.glDisableVertexAttribArray((int)0);
        }
    }

    public static void initShader() {
        if (shaderProgram == null) {
            Shader vertex = ShaderLoader.load("fluxloading:shaders/loading_screen_vertex.glsl", Shader.ShaderType.VERTEX);
            Shader frag = ShaderLoader.load("fluxloading:shaders/loading_screen_frag.glsl", Shader.ShaderType.FRAGMENT);
            shaderProgram = new ShaderProgram(vertex, frag);
            shaderProgram.setup();
            FluxLoading.logger.info(shaderProgram.getSetupDebugReport());
            shaderProgram.use();
            shaderProgram.setUniform("screenTexture", 1);
            shaderProgram.setUniform("percentage", Float.valueOf(0.0f));
            shaderProgram.setUniform("enableDissolving", false);
            shaderProgram.setUniform("enableWaving", false);
            shaderProgram.setUniform("enableDarkOverlay", FluxLoadingConfig.ENABLE_DARK_OVERLAY);
            shaderProgram.setUniform("enable3x3Blur", false);
            shaderProgram.setUniform("enable5x5Blur", false);
            shaderProgram.setUniform("enableKawaseBlur", false);
            shaderProgram.setUniform("targetBlurStrength", Float.valueOf(1.0f));
            if (FluxLoadingConfig.ENABLE_BLUR) {
                switch (FluxLoadingConfig.BLUR_ALGORITHM) {
                    case "3x3_gaussian_blur": {
                        shaderProgram.setUniform("enable3x3Blur", true);
                        break;
                    }
                    case "5x5_gaussian_blur": {
                        shaderProgram.setUniform("enable5x5Blur", true);
                        break;
                    }
                    case "kawase_blur": {
                        shaderProgram.setUniform("enableKawaseBlur", true);
                    }
                }
                shaderProgram.setUniform("targetBlurStrength", Float.valueOf(FluxLoadingConfig.BLUR_STRENGTH));
            }
            shaderProgram.unuse();
            vertexBuffer = ByteBuffer.allocateDirect(36).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertexBuffer.put(new float[]{-1.0f, -1.0f, 0.0f, 3.0f, -1.0f, 0.0f, -1.0f, 3.0f, 0.0f}).flip();
        }
    }

    public static void resetShader() {
        if (shaderProgram != null) {
            shaderProgram.use();
            shaderProgram.setUniform("percentage", Float.valueOf(1.0f));
            shaderProgram.unuse();
        }
    }

    public static void setShaderFadingState(boolean state) {
        if (shaderProgram != null) {
            shaderProgram.use();
            if (state) {
                shaderProgram.setUniform("enableDissolving", FluxLoadingConfig.ENABLE_FADEIN_DISSOLVING_EFFECT);
                shaderProgram.setUniform("enableWaving", FluxLoadingConfig.ENABLE_FADEIN_WAVING_EFFECT);
            } else {
                shaderProgram.setUniform("enableDissolving", FluxLoadingConfig.ENABLE_FADEOUT_DISSOLVING_EFFECT);
                shaderProgram.setUniform("enableWaving", FluxLoadingConfig.ENABLE_FADEOUT_WAVING_EFFECT);
            }
            shaderProgram.unuse();
        }
    }
}

