/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.mixin.early;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tttsaurus.fluxloading.core.FluxLoadingAPI;
import com.tttsaurus.fluxloading.core.FluxLoadingManager;
import com.tttsaurus.fluxloading.core.render.RenderUtils;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LoadingScreenRenderer.class})
public class LoadingScreenRendererMixin {
    @Unique
    private BufferBuilder fluxloading$proxyBufferBuilder;

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;draw()V", ordinal=0)})
    public void draw(Tessellator instance, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            FluxLoadingManager.drawOverlayDefaultWorldLoadingAndFadingInPhase();
            FluxLoadingManager.tick();
            this.fluxloading$proxyBufferBuilder.func_178977_d();
            this.fluxloading$proxyBufferBuilder.func_178965_a();
        } else {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;getBuffer()Lnet/minecraft/client/renderer/BufferBuilder;")})
    public BufferBuilder getBuffer(Tessellator instance, Operation<BufferBuilder> original) {
        if (FluxLoadingAPI.isActive()) {
            if (this.fluxloading$proxyBufferBuilder == null) {
                this.fluxloading$proxyBufferBuilder = new BufferBuilder(25);
            }
            return this.fluxloading$proxyBufferBuilder;
        }
        return (BufferBuilder)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;framebufferClear()V")})
    public void framebufferClear(Framebuffer instance, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            return;
        }
        original.call(new Object[]{instance});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;clear(I)V")})
    public void clear(int mask, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            return;
        }
        original.call(new Object[]{mask});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;framebufferRender(II)V")})
    public void framebufferRender(Framebuffer instance, int width, int height, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            return;
        }
        original.call(new Object[]{instance, width, height});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;bindFramebuffer(Z)V")})
    public void bindFramebuffer(Framebuffer instance, boolean p_147610_1_, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            return;
        }
        original.call(new Object[]{instance, p_147610_1_});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;unbindFramebuffer()V")})
    public void unbindFramebuffer(Framebuffer instance, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            return;
        }
        original.call(new Object[]{instance});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", ordinal=0)})
    public int drawStringWithShadow0(FontRenderer instance, String text, float x, float y, int color, Operation<Integer> original) {
        if (FluxLoadingAPI.isActive() && FluxLoadingManager.isDisableVanillaTexts()) {
            return 0;
        }
        int res = (Integer)original.call(new Object[]{instance, text, Float.valueOf(x), Float.valueOf(y), color});
        if (FluxLoadingAPI.isActive()) {
            if (FluxLoadingManager.isForceLoadingTitle() && text != null && !text.isEmpty()) {
                FluxLoadingManager.setForceLoadingTitle(false);
            }
            if (FluxLoadingManager.isForceLoadingTitle()) {
                String i18nText = I18n.func_135052_a((String)"menu.loadingLevel", (Object[])new Object[0]);
                int width = RenderUtils.fontRenderer.func_78256_a(i18nText);
                RenderUtils.renderText(i18nText, x - (float)((int)((float)width / 2.0f)), y, 1.0f, color, true);
            }
        }
        return res;
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", ordinal=1)})
    public int drawStringWithShadow1(FontRenderer instance, String text, float x, float y, int color, Operation<Integer> original) {
        if (FluxLoadingAPI.isActive() && FluxLoadingManager.isDisableVanillaTexts()) {
            return 0;
        }
        return (Integer)original.call(new Object[]{instance, text, Float.valueOf(x), Float.valueOf(y), color});
    }
}

