/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.raycast;

import com.tttsaurus.fluxloading.core.raycast.Ray;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public final class FrustumChunkRayCastHelper {
    public static List<Ray> getRaysFromFrustum(Vec3d camPos, ClippingHelper clippingHelper, int horizontalCount, int verticalCount) {
        ArrayList<Ray> rays = new ArrayList<Ray>();
        Matrix4f projection = new Matrix4f();
        Matrix4f modelview = new Matrix4f();
        FloatBuffer projBuf = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer modelBuf = BufferUtils.createFloatBuffer((int)16);
        projBuf.put(clippingHelper.field_178625_b).flip();
        modelBuf.put(clippingHelper.field_178626_c).flip();
        projection.load(projBuf);
        modelview.load(modelBuf);
        Matrix4f combined = new Matrix4f();
        Matrix4f.mul((Matrix4f)projection, (Matrix4f)modelview, (Matrix4f)combined);
        Matrix4f inverse = new Matrix4f();
        Matrix4f.invert((Matrix4f)combined, (Matrix4f)inverse);
        float[][] ndcCorners = new float[][]{{-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}, {-1.0f, 1.0f}};
        Vec3d[] dirs = new Vec3d[4];
        int index = 0;
        for (float[] ndc : ndcCorners) {
            float x = ndc[0];
            float y = ndc[1];
            Vector4f clip = new Vector4f(x, y, 1.0f, 1.0f);
            Vector4f world = new Vector4f();
            Matrix4f.transform((Matrix4f)inverse, (Vector4f)clip, (Vector4f)world);
            world.x /= world.w;
            world.y /= world.w;
            world.z /= world.w;
            world.x += (float)camPos.field_72450_a;
            world.y += (float)camPos.field_72448_b;
            world.z += (float)camPos.field_72449_c;
            Vec3d farPoint = new Vec3d((double)world.x, (double)world.y, (double)world.z);
            dirs[index++] = farPoint.func_178788_d(camPos).func_72432_b();
        }
        Vec3d camDir = FrustumChunkRayCastHelper.bilerpVec3d(dirs[3], dirs[2], dirs[0], dirs[1], 0.5, 0.5);
        camPos = camPos.func_178788_d(camDir.func_186678_a(1.5));
        for (int i = 0; i < horizontalCount; ++i) {
            for (int j = 0; j < verticalCount; ++j) {
                double x = (double)i / (double)horizontalCount;
                double y = (double)j / (double)verticalCount;
                Vec3d dir = FrustumChunkRayCastHelper.bilerpVec3d(dirs[3], dirs[2], dirs[0], dirs[1], x, y);
                rays.add(new Ray(camPos, dir));
            }
        }
        return rays;
    }

    private static Vec3d bilerpVec3d(Vec3d dir00, Vec3d dir10, Vec3d dir01, Vec3d dir11, double x, double y) {
        Vec3d bottom = FrustumChunkRayCastHelper.lerpVec3d(dir00, dir10, x);
        Vec3d top = FrustumChunkRayCastHelper.lerpVec3d(dir01, dir11, x);
        Vec3d result = FrustumChunkRayCastHelper.lerpVec3d(bottom, top, y);
        return result.func_72432_b();
    }

    private static Vec3d lerpVec3d(Vec3d a, Vec3d b, double t) {
        return a.func_186678_a(1.0 - t).func_178787_e(b.func_186678_a(t));
    }

    public static int getChunkRayCastNum(List<Ray> rays, List<Chunk> chunks, double maxDistance) {
        HashSet<Long> visibleChunks = new HashSet<Long>();
        HashMap<Long, Chunk> chunkMap = new HashMap<Long, Chunk>();
        for (Chunk chunk : chunks) {
            long key = FrustumChunkRayCastHelper.chunkKey(chunk.field_76635_g, chunk.field_76647_h);
            chunkMap.put(key, chunk);
        }
        double step = 0.5;
        block1: for (Ray ray : rays) {
            Vec3d pos = ray.pos;
            Vec3d dir = ray.dir.func_72432_b();
            for (double traveled = 0.0; traveled < maxDistance; traveled += 0.5) {
                IBlockState state;
                int chunkZ;
                BlockPos blockPos = new BlockPos(pos);
                int chunkX = blockPos.func_177958_n() >> 4;
                long key = FrustumChunkRayCastHelper.chunkKey(chunkX, chunkZ = blockPos.func_177952_p() >> 4);
                Chunk chunk = (Chunk)chunkMap.get(key);
                if (chunk != null && !chunk.func_76621_g() && (state = chunk.func_177435_g(blockPos)).func_185914_p()) {
                    visibleChunks.add(key);
                    continue block1;
                }
                pos = pos.func_178787_e(dir.func_186678_a(0.5));
            }
        }
        return visibleChunks.size();
    }

    private static long chunkKey(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }
}

