/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.render;

import com.tttsaurus.fluxloading.core.render.CommonBuffers;
import com.tttsaurus.fluxloading.core.render.Texture2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private static int textureID = 0;
    private static float r = 0.0f;
    private static float g = 0.0f;
    private static float b = 0.0f;
    private static float a = 0.0f;
    private static boolean blend = false;
    private static boolean lighting = false;
    private static boolean texture2D = false;
    private static boolean alphaTest = false;
    private static int shadeModel = 0;
    private static boolean depthTest = false;
    private static boolean cullFace = false;
    private static int blendSrcRgb;
    private static int blendDstRgb;
    private static int blendSrcAlpha;
    private static int blendDstAlpha;
    private static int alphaFunc;
    private static float alphaRef;
    public static FontRenderer fontRenderer;
    public static float zLevel;

    public static void storeCommonGlStates() {
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        textureID = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetFloat((int)2816, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        r = CommonBuffers.FLOAT_BUFFER_16.get(0);
        g = CommonBuffers.FLOAT_BUFFER_16.get(1);
        b = CommonBuffers.FLOAT_BUFFER_16.get(2);
        a = CommonBuffers.FLOAT_BUFFER_16.get(3);
        blend = GL11.glIsEnabled((int)3042);
        lighting = GL11.glIsEnabled((int)2896);
        texture2D = GL11.glIsEnabled((int)3553);
        alphaTest = GL11.glIsEnabled((int)3008);
        GL11.glGetInteger((int)2900, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        shadeModel = CommonBuffers.INT_BUFFER_16.get(0);
        depthTest = GL11.glIsEnabled((int)2929);
        cullFace = GL11.glIsEnabled((int)2884);
        GL11.glGetInteger((int)32969, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendSrcRgb = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32968, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendDstRgb = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32971, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendSrcAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32970, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendDstAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)3009, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        alphaFunc = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetFloat((int)3010, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        alphaRef = CommonBuffers.FLOAT_BUFFER_16.get(0);
    }

    public static void restoreCommonGlStates() {
        GlStateManager.func_179092_a((int)alphaFunc, (float)alphaRef);
        GlStateManager.func_179120_a((int)blendSrcRgb, (int)blendDstRgb, (int)blendSrcAlpha, (int)blendDstAlpha);
        if (cullFace) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        if (depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179103_j((int)shadeModel);
        if (alphaTest) {
            GlStateManager.func_179141_d();
        } else {
            GlStateManager.func_179118_c();
        }
        if (texture2D) {
            GlStateManager.func_179098_w();
        } else {
            GlStateManager.func_179090_x();
        }
        if (lighting) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        if (blend) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179144_i((int)textureID);
    }

    public static void renderText(String text, float x, float y, float scale, int color, boolean shadow) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)zLevel);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, shadow);
        GlStateManager.func_179121_F();
    }

    public static void createPng(File directory, String fileName, ByteBuffer buffer, int width, int height) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File pngFile = new File(directory, fileName + ".png");
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (y * width + x) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, argb);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "PNG", pngFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void createPng(File directory, String fileName, BufferedImage image) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File pngFile = new File(directory, fileName + ".png");
        try {
            ImageIO.write((RenderedImage)image, "PNG", pngFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static Texture2D readPng(File png) {
        if (!png.exists()) {
            return null;
        }
        try {
            return RenderUtils.createTexture2D(ImageIO.read(png));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Nullable
    public static Texture2D createTexture2D(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width == 0 || height == 0) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        int[] pixels = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return new Texture2D(width, height, buffer);
    }

    public static Vec3d getWorldOffset() {
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (camera == null) {
            camera = Minecraft.func_71410_x().field_71439_g;
        }
        double partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double camX = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * partialTicks;
        double camY = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * partialTicks;
        double camZ = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * partialTicks;
        return new Vec3d(camX, camY, camZ);
    }

    public static Vec3d getCameraPos() {
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (camera == null) {
            camera = Minecraft.func_71410_x().field_71439_g;
        }
        double partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double camX = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * partialTicks;
        double camY = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * partialTicks + (double)camera.func_70047_e();
        double camZ = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * partialTicks;
        return new Vec3d(camX, camY, camZ);
    }

    static {
        fontRenderer = Minecraft.func_71410_x().field_71466_p;
        zLevel = 0.0f;
    }
}

