/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.render.shader;

import com.tttsaurus.fluxloading.core.render.shader.ShaderParseUtils;
import com.tttsaurus.fluxloading.core.render.shader.uniform.UniformField;
import java.util.List;
import org.lwjgl.opengl.GL20;

public class Shader {
    private String shaderSource;
    private int shaderID;
    private final ShaderType shaderType;
    private boolean valid = true;
    private String errorLog;
    private final List<UniformField> uniformFields;
    private final String fileName;

    public int getShaderID() {
        return this.shaderID;
    }

    public ShaderType getShaderType() {
        return this.shaderType;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected boolean getValidity() {
        return this.valid;
    }

    protected String getErrorLog() {
        return this.errorLog;
    }

    protected List<UniformField> getUniformFields() {
        return this.uniformFields;
    }

    public Shader(String fileName, String shaderSource, ShaderType shaderType) {
        this.fileName = fileName;
        this.shaderSource = shaderSource;
        this.shaderType = shaderType;
        this.uniformFields = ShaderParseUtils.getUniformFields(shaderSource);
    }

    protected void compile() {
        this.shaderID = GL20.glCreateShader((int)this.shaderType.glValue);
        GL20.glShaderSource((int)this.shaderID, (CharSequence)this.shaderSource);
        GL20.glCompileShader((int)this.shaderID);
        this.shaderSource = null;
        if (GL20.glGetShaderi((int)this.shaderID, (int)35713) == 0) {
            this.errorLog = GL20.glGetShaderInfoLog((int)this.shaderID, (int)1024);
            GL20.glDeleteShader((int)this.shaderID);
            this.shaderID = 0;
            this.valid = false;
        }
    }

    public static enum ShaderType {
        VERTEX(35633),
        FRAGMENT(35632),
        TESS_CONTROL(36488),
        TESS_EVALUATION(36487);

        public final int glValue;

        private ShaderType(int glValue) {
            this.glValue = glValue;
        }
    }
}

