/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.render;

import com.tttsaurus.fluxloading.core.render.Texture2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;

public final class RenderUtils {
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static float zLevel = 0.0f;

    public static void renderText(String text, float x, float y, float scale, int color, boolean shadow) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)zLevel);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, shadow);
        GlStateManager.func_179121_F();
    }

    public static void createPng(File directory, String fileName, ByteBuffer buffer, int width, int height) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File pngFile = new File(directory, fileName + ".png");
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (y * width + x) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, argb);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "PNG", pngFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void createPng(File directory, String fileName, BufferedImage image) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File pngFile = new File(directory, fileName + ".png");
        try {
            ImageIO.write((RenderedImage)image, "PNG", pngFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public static Texture2D readPng(File png) {
        if (!png.exists()) {
            return null;
        }
        try {
            return RenderUtils.createTexture2D(ImageIO.read(png));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Nullable
    public static Texture2D createTexture2D(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width == 0 || height == 0) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        int[] pixels = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return new Texture2D(width, height, buffer);
    }
}

