/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.villagerxp;

import com.juaanp.villagerxp.Constants;
import com.juaanp.villagerxp.VillagerUtils;
import com.juaanp.villagerxp.config.CommonConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class VillagerEventHandler {
    private final CommonConfig config;
    private final VillagerUtils villagerUtils;

    public VillagerEventHandler(CommonConfig config) {
        this.config = config;
        this.villagerUtils = new VillagerUtils(config);
    }

    public InteractionResult handleVillagerInteraction(Player player, Level level, ItemStack stack, Villager villager) {
        if (stack.is(Items.EXPERIENCE_BOTTLE) && this.config.isXpBottlesEnabled()) {
            if (this.config.requiresCrouching() && !player.isCrouching()) {
                return InteractionResult.PASS;
            }
            if (this.villagerUtils.canLevelUp(villager) && !this.villagerUtils.unemployed(villager)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.config.getLevelsPerBottle() == 0) {
                        this.villagerUtils.giveXP(villager, level, 2.2f * this.config.getBottleXpMultiplier());
                    } else if (this.config.getLevelsPerBottle() >= 1 && this.config.getLevelsPerBottle() <= 4) {
                        int currentLevel = villager.getVillagerData().getLevel();
                        int targetLevel = Math.min(5, currentLevel + this.config.getLevelsPerBottle());
                        while (this.villagerUtils.canLevelUp(villager) && villager.getVillagerData().getLevel() < targetLevel) {
                            this.villagerUtils.levelUp(villager);
                        }
                        this.villagerUtils.spawnLevelUpParticles(villager);
                        this.villagerUtils.spawnXPParticles(villager, serverLevel, villager.getRandom());
                        this.villagerUtils.playSound(villager, villager.getRandom());
                    } else {
                        Constants.LOG.error("Wrong levels per bottle, reset settings to default!");
                        this.config.setLevelsPerBottle(0);
                        return InteractionResult.PASS;
                    }
                    if (!player.isCreative() && !player.hasInfiniteMaterials()) {
                        stack.shrink(1);
                    }
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

