/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.villagerxp;

import com.juaanp.villagerxp.access.VillagerAccessor;
import com.juaanp.villagerxp.config.CommonConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;

public class VillagerUtils {
    private final CommonConfig config;

    public VillagerUtils(CommonConfig config) {
        this.config = config;
    }

    public void giveXP(Villager villager, Level level) {
        this.giveXP(villager, level, 1.0f);
    }

    public void giveXP(Villager villager, Level level, float multiplier) {
        RandomSource random = villager.getRandom();
        villager.setVillagerXp((int)((float)villager.getVillagerXp() + (float)this.config.getXpAmount() * multiplier));
        this.playSound(villager, random);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnXPParticles(villager, serverLevel, random);
            villager.playCelebrateSound();
            if (this.shouldLevelUp(villager)) {
                this.levelUp(villager);
                this.spawnLevelUpParticles(villager);
            }
        }
    }

    public boolean shouldLevelUp(Villager villager) {
        int i = villager.getVillagerData().getLevel();
        return VillagerData.canLevelUp((int)i) && villager.getVillagerXp() >= VillagerData.getMaxXpPerLevel((int)i);
    }

    public boolean canLevelUp(Villager villager) {
        int i = villager.getVillagerData().getLevel();
        return VillagerData.canLevelUp((int)i);
    }

    public void levelUp(Villager villager) {
        if (villager instanceof VillagerAccessor) {
            VillagerAccessor accessor = (VillagerAccessor)villager;
            accessor.invokeIncreaseMerchantCareer();
            accessor.invokeResendOffersToTradingPlayer();
            this.resetLevelXP(villager, villager.getVillagerData().getLevel());
        }
    }

    public void resetLevelXP(Villager villager, int level) {
        villager.setVillagerXp(VillagerData.getMinXpPerLevel((int)level));
    }

    public boolean unemployed(Villager villager) {
        return villager.getVillagerData().getProfession() == VillagerProfession.NONE;
    }

    public void spawnLevelUpParticles(Villager villager) {
        villager.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
    }

    public void spawnXPParticles(Villager villager, ServerLevel serverLevel, RandomSource random) {
        for (int i = 0; i < 5; ++i) {
            double dx = random.nextGaussian() * 0.02;
            double dy = random.nextGaussian() * 0.02;
            double dz = random.nextGaussian() * 0.02;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, villager.getRandomX(1.0), villager.getRandomY() + 0.5, villager.getRandomZ(1.0), 1, dx, dy, dz, 0.0);
        }
    }

    public void playSound(Villager villager, RandomSource random) {
        villager.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.1f, (random.nextFloat() - random.nextFloat()) * 0.35f + 0.9f);
    }
}

