/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.villagerxp.client;

import com.juaanp.villagerxp.config.CommonConfig;
import com.juaanp.villagerxp.config.ConfigHelper;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigScreenBase
extends OptionsSubScreen {
    private static final Component TITLE = Component.translatable((String)"villagerxp.config.title");
    private static final Component RESET = Component.translatable((String)"villagerxp.config.reset");
    private static final Component ORBS_CATEGORY = Component.translatable((String)"villagerxp.config.category.orbs");
    private static final Component BOTTLES_CATEGORY = Component.translatable((String)"villagerxp.config.category.bottles");
    protected final Options options;
    protected Button resetButton;
    protected final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build();
    private Integer lastXpAmount = null;
    private Boolean lastBottlesEnabled = null;
    private Boolean lastOrbsEnabled = null;
    private Boolean lastRequireCrouching = null;
    private Float lastBottleMultiplier = null;
    private Float lastOrbMultiplier = null;
    private Double lastOrbAttractRange = null;
    private Double lastOrbPickupRange = null;
    private Integer lastLevelsPerBottle = null;
    private Boolean lastShowOrbRanges = null;

    public ConfigScreenBase(Screen lastScreen, Options options) {
        super(lastScreen, options, TITLE);
        this.options = options;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.setResetButtonState(this.isAnyNonDefault());
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void createResetButton() {
        this.resetButton = Button.builder((Component)RESET, button -> this.resetToDefaults()).width(120).build();
    }

    protected void setResetButtonState(boolean state) {
        if (this.resetButton != null) {
            this.resetButton.active = state;
        }
    }

    protected boolean isAnyNonDefault() {
        return this.getXpAmount() != CommonConfig.getDefaultXpAmount() || this.getXpBottlesEnabled() != CommonConfig.getDefaultXpBottlesEnabled() || this.getXpOrbsEnabled() != CommonConfig.getDefaultXpOrbsEnabled() || this.getRequireCrouching() != CommonConfig.getDefaultRequiresCrouching() || this.getBottleXpMultiplier() != CommonConfig.getDefaultBottleXpMultiplier() || this.getOrbXpMultiplier() != CommonConfig.getDefaultOrbXpMultiplier() || this.getOrbAttractRange() != CommonConfig.getDefaultOrbAttractRange() || this.getOrbPickupRange() != CommonConfig.getDefaultOrbPickupRange() || this.getLevelsPerBottle() != CommonConfig.getDefaultLevelsPerBottle();
    }

    private void resetToDefaults() {
        this.setOrbPickupRange(CommonConfig.getDefaultOrbPickupRange());
        this.setOrbAttractRange(CommonConfig.getDefaultOrbAttractRange());
        this.setXpAmount(CommonConfig.getDefaultXpAmount());
        this.setXpBottlesEnabled(CommonConfig.getDefaultXpBottlesEnabled());
        this.setXpOrbsEnabled(CommonConfig.getDefaultXpOrbsEnabled());
        this.setRequireCrouching(CommonConfig.getDefaultRequiresCrouching());
        this.setBottleXpMultiplier(CommonConfig.getDefaultBottleXpMultiplier());
        this.setOrbXpMultiplier(CommonConfig.getDefaultOrbXpMultiplier());
        this.setLevelsPerBottle(CommonConfig.getDefaultLevelsPerBottle());
        this.saveConfig();
        this.minecraft.setScreen(this.lastScreen);
        this.minecraft.setScreen((Screen)new ConfigScreenBase(this.lastScreen, this.options));
    }

    protected void addOptions() {
        if (this.resetButton == null) {
            this.createResetButton();
        }
        this.initializeTrackingFields();
        OptionInstance bottleToggle = OptionInstance.createBoolean((String)"villagerxp.config.enable", (boolean)this.getXpBottlesEnabled(), this::setXpBottlesEnabled);
        OptionInstance orbToggle = OptionInstance.createBoolean((String)"villagerxp.config.enable", (boolean)this.getXpOrbsEnabled(), this::setXpOrbsEnabled);
        OptionInstance crouchToggle = OptionInstance.createBoolean((String)"villagerxp.config.requireCtrl", (boolean)this.getRequireCrouching(), this::setRequireCrouching);
        OptionInstance bottleMultiplier = new OptionInstance("villagerxp.config.xpMultiplier", OptionInstance.noTooltip(), (prefix, value) -> prefix.copy().append(": ").append((Component)(Math.abs(value - 1.0) < 0.05 ? Component.translatable((String)"villagerxp.config.default") : Component.literal((String)String.format("%.1f", value)))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(value -> 0.1 + value * 4.9, value -> (value - 0.1) / 4.9), (Object)this.getBottleXpMultiplier(), value -> this.setBottleXpMultiplier(value.floatValue()));
        OptionInstance orbMultiplier = new OptionInstance("villagerxp.config.xpMultiplier", OptionInstance.noTooltip(), (prefix, value) -> prefix.copy().append(": ").append((Component)(Math.abs(value - 1.0) < 0.05 ? Component.translatable((String)"villagerxp.config.default") : Component.literal((String)String.format("%.1f", value)))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(value -> 0.1 + value * 4.9, value -> (value - 0.1) / 4.9), (Object)this.getOrbXpMultiplier(), value -> this.setOrbXpMultiplier(value.floatValue()));
        OptionInstance orbAttractRangeOption = new OptionInstance("villagerxp.config.orbAttractRange", OptionInstance.noTooltip(), (component, value) -> component.copy().append(": ").append((Component)(Math.abs(value - 4.5) < 0.05 ? Component.translatable((String)"villagerxp.config.default") : Component.literal((String)String.format("%.1f", value)))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(value -> 1.0 + value * 15.0, value -> (value - 1.0) / 15.0), (Object)this.getOrbAttractRange(), this::setOrbAttractRange);
        OptionInstance orbPickupRangeOption = new OptionInstance("villagerxp.config.orbPickupRange", OptionInstance.noTooltip(), (component, value) -> component.copy().append(": ").append((Component)(Math.abs(value - 1.5) < 0.05 ? Component.translatable((String)"villagerxp.config.default") : Component.literal((String)String.format("%.1f", value)))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE.xmap(value -> 0.5 + value * 9.5, value -> (value - 0.5) / 9.5), (Object)this.getOrbPickupRange(), this::setOrbPickupRange);
        OptionInstance levelsPerBottleOption = new OptionInstance("villagerxp.config.levelsPerBottle", OptionInstance.noTooltip(), (component, value) -> {
            MutableComponent display = value == 0 ? Component.translatable((String)"villagerxp.config.auto") : (value == 4 ? Component.translatable((String)"villagerxp.config.max") : Component.literal((String)String.valueOf(value)));
            return component.copy().append(": ").append((Component)display);
        }, (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 4), (Object)this.getLevelsPerBottle(), this::setLevelsPerBottle);
        StringWidget orbsHeader = new StringWidget(ORBS_CATEGORY, this.font);
        StringWidget bottlesHeader = new StringWidget(BOTTLES_CATEGORY, this.font);
        this.list.addSmall((AbstractWidget)new EmptyWidget(10, 8), (AbstractWidget)new EmptyWidget(10, 8));
        this.list.addSmall((AbstractWidget)orbsHeader, null);
        this.list.addBig(orbToggle);
        this.list.addBig(orbMultiplier);
        this.list.addBig(orbAttractRangeOption);
        this.list.addBig(orbPickupRangeOption);
        this.list.addSmall((AbstractWidget)new EmptyWidget(10, 16), (AbstractWidget)new EmptyWidget(10, 16));
        this.list.addSmall((AbstractWidget)bottlesHeader, null);
        this.list.addBig(bottleToggle);
        this.list.addBig(bottleMultiplier);
        this.list.addBig(levelsPerBottleOption);
        this.list.addBig(crouchToggle);
    }

    private void initializeTrackingFields() {
        this.lastXpAmount = this.getXpAmount();
        this.lastBottlesEnabled = this.getXpBottlesEnabled();
        this.lastOrbsEnabled = this.getXpOrbsEnabled();
        this.lastRequireCrouching = this.getRequireCrouching();
        this.lastBottleMultiplier = Float.valueOf(this.getBottleXpMultiplier());
        this.lastOrbMultiplier = Float.valueOf(this.getOrbXpMultiplier());
        this.lastOrbAttractRange = this.getOrbAttractRange();
        this.lastOrbPickupRange = this.getOrbPickupRange();
        this.lastLevelsPerBottle = this.getLevelsPerBottle();
    }

    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        if (this.resetButton != null) {
            linearLayout.addChild((LayoutElement)this.resetButton);
            linearLayout.addChild((LayoutElement)this.doneButton);
        } else {
            super.addFooter();
        }
    }

    protected int getXpAmount() {
        return CommonConfig.getInstance().getXpAmount();
    }

    protected void setXpAmount(int amount) {
        CommonConfig.getInstance().setXpAmount(amount);
    }

    protected boolean getXpBottlesEnabled() {
        return CommonConfig.getInstance().isXpBottlesEnabled();
    }

    protected void setXpBottlesEnabled(boolean enabled) {
        CommonConfig.getInstance().setXpBottlesEnabled(enabled);
    }

    protected boolean getXpOrbsEnabled() {
        return CommonConfig.getInstance().isXpOrbsEnabled();
    }

    protected void setXpOrbsEnabled(boolean enabled) {
        CommonConfig.getInstance().setXpOrbsEnabled(enabled);
    }

    protected boolean getRequireCrouching() {
        return CommonConfig.getInstance().requiresCrouching();
    }

    protected void setRequireCrouching(boolean require) {
        CommonConfig.getInstance().setRequiresCrouching(require);
    }

    protected float getBottleXpMultiplier() {
        return CommonConfig.getInstance().getBottleXpMultiplier();
    }

    protected void setBottleXpMultiplier(float multiplier) {
        CommonConfig.getInstance().setBottleXpMultiplier(multiplier);
    }

    protected float getOrbXpMultiplier() {
        return CommonConfig.getInstance().getOrbXpMultiplier();
    }

    protected void setOrbXpMultiplier(float multiplier) {
        CommonConfig.getInstance().setOrbXpMultiplier(multiplier);
    }

    protected double getOrbAttractRange() {
        return CommonConfig.getInstance().getOrbAttractRange();
    }

    protected void setOrbAttractRange(double orbAttractRange) {
        CommonConfig.getInstance().setOrbAttractRange(orbAttractRange);
    }

    protected double getOrbPickupRange() {
        return CommonConfig.getInstance().getOrbPickupRange();
    }

    protected void setOrbPickupRange(double orbPickupRange) {
        CommonConfig.getInstance().setOrbPickupRange(orbPickupRange);
    }

    protected int getLevelsPerBottle() {
        return CommonConfig.getInstance().getLevelsPerBottle();
    }

    protected void setLevelsPerBottle(int levels) {
        CommonConfig.getInstance().setLevelsPerBottle(levels);
    }

    protected void saveConfig() {
        ConfigHelper.save();
    }

    public void onClose() {
        this.saveConfig();
        super.onClose();
    }

    public void removed() {
        this.saveConfig();
        super.removed();
    }

    private static class EmptyWidget
    extends AbstractWidget {
        public EmptyWidget(int width, int height) {
            super(0, 0, width, height, (Component)Component.empty());
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

