/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.villagerxp.config;

public class CommonConfig {
    private static CommonConfig instance;
    private int xpAmount = 10;
    private boolean xpBottlesEnabled = true;
    private boolean xpOrbsEnabled = true;
    private boolean requiresCrouching = true;
    private float bottleXpMultiplier = 1.0f;
    private float orbXpMultiplier = 1.0f;
    private double orbAttractRange = 4.5;
    private double orbPickupRange = 1.5;
    private int levelsPerBottle = 0;

    private CommonConfig() {
    }

    public static CommonConfig getInstance() {
        if (instance == null) {
            instance = new CommonConfig();
        }
        return instance;
    }

    public static int getDefaultXpAmount() {
        return 10;
    }

    public static boolean getDefaultXpBottlesEnabled() {
        return true;
    }

    public static boolean getDefaultXpOrbsEnabled() {
        return true;
    }

    public static boolean getDefaultRequiresCrouching() {
        return true;
    }

    public static float getDefaultBottleXpMultiplier() {
        return 1.0f;
    }

    public static float getDefaultOrbXpMultiplier() {
        return 1.0f;
    }

    public static double getDefaultOrbAttractRange() {
        return 4.5;
    }

    public static double getDefaultOrbPickupRange() {
        return 1.5;
    }

    public static int getDefaultLevelsPerBottle() {
        return 0;
    }

    public int getXpAmount() {
        return this.xpAmount;
    }

    public void setXpAmount(int xpAmount) {
        this.xpAmount = xpAmount;
    }

    public boolean isXpBottlesEnabled() {
        return this.xpBottlesEnabled;
    }

    public void setXpBottlesEnabled(boolean xpBottlesEnabled) {
        this.xpBottlesEnabled = xpBottlesEnabled;
    }

    public boolean isXpOrbsEnabled() {
        return this.xpOrbsEnabled;
    }

    public void setXpOrbsEnabled(boolean xpOrbsEnabled) {
        this.xpOrbsEnabled = xpOrbsEnabled;
    }

    public boolean requiresCrouching() {
        return this.requiresCrouching;
    }

    public void setRequiresCrouching(boolean requiresCrouching) {
        this.requiresCrouching = requiresCrouching;
    }

    public float getBottleXpMultiplier() {
        return this.bottleXpMultiplier;
    }

    public void setBottleXpMultiplier(float bottleXpMultiplier) {
        this.bottleXpMultiplier = bottleXpMultiplier;
    }

    public float getOrbXpMultiplier() {
        return this.orbXpMultiplier;
    }

    public void setOrbXpMultiplier(float orbXpMultiplier) {
        this.orbXpMultiplier = orbXpMultiplier;
    }

    public double getOrbAttractRange() {
        return this.orbAttractRange;
    }

    public void setOrbAttractRange(double orbAttractRange) {
        this.orbAttractRange = Math.max(orbAttractRange, this.orbPickupRange);
    }

    public double getOrbPickupRange() {
        return this.orbPickupRange;
    }

    public void setOrbPickupRange(double orbPickupRange) {
        this.orbPickupRange = orbPickupRange;
        if (this.orbAttractRange < orbPickupRange) {
            this.orbAttractRange = orbPickupRange;
        }
    }

    public int getLevelsPerBottle() {
        return this.levelsPerBottle;
    }

    public void setLevelsPerBottle(int levelsPerBottle) {
        this.levelsPerBottle = levelsPerBottle;
    }
}

