/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.villagerxp.platform;

import com.juaanp.villagerxp.config.CommonConfig;
import com.juaanp.villagerxp.platform.IPlatformHelper;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue XP_AMOUNT = BUILDER.comment("villagerxp.config.xpAmount.tooltip").translation("villagerxp.config.xpAmount").defineInRange("xpAmount", CommonConfig.getDefaultXpAmount(), 0, 150);
    public static final ModConfigSpec.BooleanValue ENABLE_XP_BOTTLES = BUILDER.comment("villagerxp.config.enableXpBottles.tooltip").translation("villagerxp.config.enableXpBottles").define("enableXpBottles", CommonConfig.getDefaultXpBottlesEnabled());
    public static final ModConfigSpec.BooleanValue ENABLE_XP_ORBS = BUILDER.comment("villagerxp.config.enableXpOrbs.tooltip").translation("villagerxp.config.enableXpOrbs").define("enableXpOrbs", CommonConfig.getDefaultXpOrbsEnabled());
    public static final ModConfigSpec.BooleanValue REQUIRES_CROUCHING = BUILDER.comment("villagerxp.config.requiresCrouching.tooltip").translation("villagerxp.config.requiresCrouching").define("requiresCrouching", CommonConfig.getDefaultRequiresCrouching());
    public static final ModConfigSpec.DoubleValue BOTTLE_XP_MULTIPLIER = BUILDER.comment("villagerxp.config.bottleMultiplier.tooltip").translation("villagerxp.config.bottleMultiplier").defineInRange("bottleMultiplier", (double)CommonConfig.getDefaultBottleXpMultiplier(), 0.1, 5.0);
    public static final ModConfigSpec.DoubleValue ORB_XP_MULTIPLIER = BUILDER.comment("villagerxp.config.orbMultiplier.tooltip").translation("villagerxp.config.orbMultiplier").defineInRange("orbMultiplier", (double)CommonConfig.getDefaultOrbXpMultiplier(), 0.1, 5.0);
    public static final ModConfigSpec.DoubleValue ORB_ATTRACT_RANGE = BUILDER.comment("villagerxp.config.orbAttractRange.tooltip").translation("villagerxp.config.orbAttractRange").defineInRange("orbAttractRange", CommonConfig.getDefaultOrbAttractRange(), 1.0, 16.0);
    public static final ModConfigSpec.DoubleValue ORB_PICKUP_RANGE = BUILDER.comment("villagerxp.config.orbPickupRange.tooltip").translation("villagerxp.config.orbPickupRange").defineInRange("orbPickupRange", CommonConfig.getDefaultOrbPickupRange(), 0.5, 10.0);
    public static final ModConfigSpec.IntValue LEVELS_PER_BOTTLE = BUILDER.comment("villagerxp.config.levelsPerBottle.tooltip").translation("villagerxp.config.levelsPerBottle").defineInRange("levelsPerBottle", CommonConfig.getDefaultLevelsPerBottle(), 0, 4);
    public static final ModConfigSpec SPEC = BUILDER.build();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void loadConfig() {
        this.applyToCommonConfig();
    }

    @Override
    public void saveConfig() {
        this.saveToNeoForgeConfig();
    }

    private void applyToCommonConfig() {
        CommonConfig common = CommonConfig.getInstance();
        common.setXpAmount((Integer)XP_AMOUNT.get());
        common.setXpBottlesEnabled((Boolean)ENABLE_XP_BOTTLES.get());
        common.setXpOrbsEnabled((Boolean)ENABLE_XP_ORBS.get());
        common.setRequiresCrouching((Boolean)REQUIRES_CROUCHING.get());
        common.setBottleXpMultiplier(((Double)BOTTLE_XP_MULTIPLIER.get()).floatValue());
        common.setOrbXpMultiplier(((Double)ORB_XP_MULTIPLIER.get()).floatValue());
        common.setOrbAttractRange((Double)ORB_ATTRACT_RANGE.get());
        common.setOrbPickupRange((Double)ORB_PICKUP_RANGE.get());
        common.setLevelsPerBottle((Integer)LEVELS_PER_BOTTLE.get());
    }

    private void saveToNeoForgeConfig() {
        CommonConfig common = CommonConfig.getInstance();
        XP_AMOUNT.set((Object)common.getXpAmount());
        ENABLE_XP_BOTTLES.set((Object)common.isXpBottlesEnabled());
        ENABLE_XP_ORBS.set((Object)common.isXpOrbsEnabled());
        REQUIRES_CROUCHING.set((Object)common.requiresCrouching());
        BOTTLE_XP_MULTIPLIER.set((Object)common.getBottleXpMultiplier());
        ORB_XP_MULTIPLIER.set((Object)common.getOrbXpMultiplier());
        ORB_ATTRACT_RANGE.set((Object)common.getOrbAttractRange());
        ORB_PICKUP_RANGE.set((Object)common.getOrbPickupRange());
        LEVELS_PER_BOTTLE.set((Object)common.getLevelsPerBottle());
    }
}

