package band.kessokuteatime.splasher.base;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;

public enum FormattingType {
	NONE(null, 0.5),
	STRIKETHROUGH(ChatFormatting.STRIKETHROUGH, 0.12),
	UNDERLINE(ChatFormatting.UNDERLINE, 0.75),
	ITALIC(ChatFormatting.ITALIC, 0.8),
	BOLD(ChatFormatting.BOLD, 0.03),
	OBFUSCATED(ChatFormatting.OBFUSCATED, 1);

	@Nullable
	private final ChatFormatting formatting;
	private final double weight; // Between 0 and 1


	FormattingType(@Nullable ChatFormatting formatting, double weight) {
		this.formatting = formatting;
		this.weight = Mth.clamp(weight, 0, 1);
	}

	public double getWeight() {
		return weight;
	}

	@Nullable
	public ChatFormatting getFormatting() {
		return formatting;
	}

	public static ArrayList<ChatFormatting> getFormatting(double weight) {
		return Arrays.stream(FormattingType.values())
				.filter(formattingType -> Math.abs(formattingType.weight - Mth.clamp(weight, 0, 1))<= 0.17)
				.collect(ArrayList::new, (list, f) -> list.add(f.formatting), ArrayList::addAll);
	}
}
