package band.kessokuteatime.splasher.mixin;

import band.kessokuteatime.splasher.Splasher;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(SplashRenderer.class)
public class SplashTextColorer {
	@Redirect(
			method = "render",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Ljava/lang/String;III)V"
			)
	)
	private void colorSplashText(GuiGraphics context, Font textRenderer, String text, int xCentered, int y, int color) {
		context.drawCenteredString(
				textRenderer, Splasher.getFormattedSplashText(text),
				xCentered, y, Splasher.CONFIG.get().texts.colorful ? Splasher.getColor() : color
		);
	}
}
