/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent;

import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEvent;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventAction;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventActions;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTEnd;
import dev.onelili.unichat.lib.packetevents.resources.ResourceLocation;
import dev.onelili.unichat.lib.packetevents.util.adventure.NbtTagHolder;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CustomClickEvent
implements ClickEvent {
    private final ResourceLocation id;
    private final @Nullable NBT payload;

    public CustomClickEvent(ResourceLocation id, @Nullable NBT payload) {
        this.id = id;
        this.payload = payload;
    }

    public static CustomClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        ResourceLocation id = compound.getOrThrow("id", ResourceLocation::decode, wrapper);
        NBT payload = compound.getTagOrNull("payload");
        return new CustomClickEvent(id, payload);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, CustomClickEvent clickEvent) {
        compound.set("id", clickEvent.id, ResourceLocation::encode, wrapper);
        if (clickEvent.payload != null) {
            compound.setTag("payload", clickEvent.payload);
        }
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.CUSTOM;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.custom((Key)this.id.key(), (BinaryTagHolder)new NbtTagHolder(this.payload != null ? this.payload : NBTEnd.INSTANCE));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public @Nullable NBT getPayload() {
        return this.payload;
    }
}

