/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent;

import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEvent;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventAction;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventActions;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTString;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RunCommandClickEvent
implements ClickEvent {
    private final String command;

    public RunCommandClickEvent(String command) {
        this.command = command;
    }

    public static RunCommandClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        String command = compound.getStringTagValueOrThrow(v1215 ? "command" : "value");
        return new RunCommandClickEvent(command);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, RunCommandClickEvent clickEvent) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        compound.setTag(v1215 ? "command" : "value", new NBTString(clickEvent.command));
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.RUN_COMMAND;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.runCommand((String)this.command);
    }

    public String getCommand() {
        return this.command;
    }
}

